/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.network;

import com.mafuyu404.diligentstalker.entity.ArrowStalkerEntity;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.network.Packet;
import com.mafuyu404.diligentstalker.registry.StalkerItems;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StalkerSyncPacket(int entityId, boolean state) implements Packet
{
    public static final CustomPacketPayload.Type<StalkerSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"stalker_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, StalkerSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StalkerSyncPacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, StalkerSyncPacket::state, StalkerSyncPacket::new);

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ? extends Packet> getStreamCodec() {
        return STREAM_CODEC;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StalkerSyncPacket msg, IPayloadContext ctx) {
        if (ctx.flow().isServerbound()) {
            ctx.enqueueWork(() -> {
                Player player = ctx.player();
                Level level = player.level();
                Entity stalker = level.getEntity(msg.entityId);
                if (stalker == null) {
                    return;
                }
                if (msg.state) {
                    if (!Stalker.hasInstanceOf((Entity)player) && !Stalker.hasInstanceOf(stalker)) {
                        Stalker.connect(player, stalker);
                    }
                } else {
                    if (Stalker.hasInstanceOf((Entity)player)) {
                        Stalker.getInstanceOf((Entity)player).disconnect();
                    }
                    player.inventoryMenu.sendAllDataToRemote();
                    player.getPersistentData().putBoolean("LoadingCacheChunk", true);
                    if (stalker instanceof ArrowStalkerEntity) {
                        ArrowStalkerEntity arrowStalker = (ArrowStalkerEntity)stalker;
                        arrowStalker.spawnAtLocation(new ItemStack((ItemLike)StalkerItems.ARROW_STALKER.get()));
                        arrowStalker.discard();
                    }
                }
            });
        }
    }
}

