/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.render;

import com.mafuyu404.diligentstalker.entity.DroneStalkerEntity;
import com.mafuyu404.diligentstalker.render.DroneStalkerModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class DroneStalkerRenderer
extends EntityRenderer<DroneStalkerEntity> {
    private static final ResourceLocation TOP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"textures/entity/drone_stalker_top.png");
    private static final ResourceLocation BOTTOM_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"textures/entity/drone_stalker_bottom.png");
    private static final ResourceLocation FORWARD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"textures/entity/drone_stalker_forward.png");
    private static final ResourceLocation SIDE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"textures/entity/drone_stalker_side.png");
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"drone_stalker"), "main");
    private final DroneStalkerModel model;

    public DroneStalkerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new DroneStalkerModel(context.bakeLayer(LAYER));
    }

    public void render(DroneStalkerEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.yRotO));
        poseStack.scale(0.8f, 0.8f, 0.8f);
        poseStack.translate(-0.5, 0.0, -0.5);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TOP_TEXTURE));
        this.model.top.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)BOTTOM_TEXTURE));
        this.model.bottom.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)FORWARD_TEXTURE));
        this.model.north.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)SIDE_TEXTURE));
        this.model.south.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)SIDE_TEXTURE));
        this.model.east.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        this.model.west.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(DroneStalkerEntity entity) {
        return TOP_TEXTURE;
    }
}

