/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.utils;

import com.mafuyu404.diligentstalker.DiligentStalker;
import com.mafuyu404.diligentstalker.event.handler.ChunkLoadTask;
import com.mafuyu404.diligentstalker.event.handler.StalkerControl;
import com.mafuyu404.diligentstalker.init.NetworkHandler;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.network.ServerRemoteConnectPacket;
import com.mafuyu404.diligentstalker.utils.ControllableUtils;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.glfw.GLFW;

public class ClientStalkerUtil {
    private static Predicate<Entity> ConnectingTarget;
    private static BlockPos VisualCenter;

    public static boolean isKeyPressed(int glfwKeyCode) {
        Minecraft minecraft = Minecraft.getInstance();
        long windowHandle = minecraft.getWindow().getWindow();
        return GLFW.glfwGetKey((long)windowHandle, (int)glfwKeyCode) == 1;
    }

    public static void updateFuel(int id, int fuel) {
        ClientLevel level = Minecraft.getInstance().level;
        Entity entity = level.getEntity(id);
        ControllableUtils.setFuel(entity, fuel);
    }

    public static void updateStorage() {
    }

    public static void clientConnect(int id) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        Entity entity = level.getEntity(id);
        Stalker.connect((Player)player, entity);
    }

    public static Vec3 getCameraPosition() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
    }

    public static boolean handleChunkPacket(ClientboundLevelChunkWithLightPacket packet) {
        ChunkPos cameraPos;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        ChunkPos pos = new ChunkPos(packet.getX(), packet.getZ());
        if (pos.equals((Object)(cameraPos = new ChunkPos(BlockPos.containing((Position)ClientStalkerUtil.getCameraPosition()))))) {
            return false;
        }
        if (Stalker.hasInstanceOf((Entity)player)) {
            ChunkLoadTask.enqueue(packet);
            DiligentStalker.debug(ClientStalkerUtil.class, "queued chunk packet x={} z={}", pos.x, pos.z);
            return true;
        }
        return false;
    }

    public static void setConnectingTarget(Predicate<Entity> predicate) {
        ConnectingTarget = predicate;
    }

    public static boolean matchConnectingTarget(Entity entity) {
        if (ConnectingTarget != null) {
            return ConnectingTarget.test(entity);
        }
        return false;
    }

    public static void setVisualCenter(BlockPos blockPos) {
        if (Stalker.hasInstanceOf((Entity)Minecraft.getInstance().player)) {
            return;
        }
        VisualCenter = blockPos;
    }

    public static BlockPos getVisualCenter() {
        if (VisualCenter == null) {
            return null;
        }
        return VisualCenter.equals((Object)BlockPos.ZERO) ? null : VisualCenter;
    }

    public static void tryRemoteConnect(BlockPos center, Predicate<Entity> predicate) {
        ClientStalkerUtil.setVisualCenter(center);
        NetworkHandler.sendToServer(new ServerRemoteConnectPacket(center));
        ClientStalkerUtil.setConnectingTarget(predicate);
    }

    public static void cancelRemoteConnect() {
        ClientStalkerUtil.setVisualCenter(BlockPos.ZERO);
        NetworkHandler.sendToServer(new ServerRemoteConnectPacket(BlockPos.ZERO));
        ClientStalkerUtil.setConnectingTarget(null);
    }

    public static Entity getLocalStalker() {
        Stalker instance = Stalker.getInstanceOf((Entity)Minecraft.getInstance().player);
        if (instance != null) {
            return instance.getStalker();
        }
        return null;
    }

    public static void setLocalViewXRot(float value) {
        StalkerControl.xRot = value;
    }

    public static void setLocalViewYRot(float value) {
        StalkerControl.yRot = value;
    }

    public static float getCameraXRot() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().getXRot();
    }

    public static float getCameraYRot() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().getYRot();
    }
}

