/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.utils;

import com.mafuyu404.diligentstalker.api.ObjectPool;
import com.mafuyu404.diligentstalker.entity.VoidStalkerEntity;
import com.mafuyu404.diligentstalker.registry.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class StalkerUtil {
    private static final ConcurrentHashMap<String, Set<ChunkPos>> CHUNK_CACHE = new ConcurrentHashMap();
    private static final long CHUNK_CACHE_EXPIRE = 5000L;
    public static HashMap<String, Integer> ControlMap = new HashMap();
    private static long lastChunkCacheCleanup = 0L;
    private static final ConcurrentHashMap<Long, ChunkPos> CHUNK_POS_CACHE = new ConcurrentHashMap();

    private static void initControlMap() {
        ControlMap.put("Up", 0);
        ControlMap.put("Down", 0);
        ControlMap.put("Left", 0);
        ControlMap.put("Right", 0);
        ControlMap.put("Jump", 0);
        ControlMap.put("Shift", 0);
    }

    public static CompoundTag getEmptyInput() {
        if (ControlMap.isEmpty()) {
            StalkerUtil.initControlMap();
        }
        CompoundTag input = new CompoundTag();
        ControlMap.forEach((s, integer) -> input.putBoolean(s, false));
        return input;
    }

    public static double lerp(double current, double target) {
        return current + (target - current) * 0.2;
    }

    public static Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float getXRotFromVec3(Vec3 vec) {
        return (float)Math.toDegrees(Math.asin(-vec.y));
    }

    public static float getYRotFromVec3(Vec3 vec) {
        return (float)Math.toDegrees(Math.atan2(-vec.x, vec.z));
    }

    public static Vec3 limitSpeed(Vec3 motion, float speed) {
        float length = (float)motion.length();
        if ((float)Math.round(length * 100.0f) / 100.0f > speed) {
            float scale = speed / length;
            motion = motion.scale((double)scale);
        }
        return motion;
    }

    public static double calculateViewAlignment(Vec3 target, Vec3 start, Vec3 end) {
        Vec3 direction = end.subtract(start);
        if (direction.length() < 1.0E-6) {
            return 0.0;
        }
        Vec3 directionNormalized = direction.normalize();
        Vec3 viewVector = target.normalize();
        double dotProduct = directionNormalized.dot(viewVector);
        return (dotProduct + 1.0) / 2.0;
    }

    public static BlockHitResult rayTraceBlocks(Level world, Entity actor, Vec3 startPos, Vec3 direction, double maxDistance) {
        Vec3 endPos = startPos.add(direction.scale(maxDistance));
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, actor);
        return world.clip(clipContext);
    }

    public static Set<ChunkPos> getToLoadChunks(Entity stalker, int offset) {
        String cacheKey;
        Set<ChunkPos> cached;
        if (stalker == null) {
            return Collections.emptySet();
        }
        ChunkPos center = stalker.chunkPosition();
        int radius = (Integer)Config.RENDER_RADIUS_NORMAL.get() + offset;
        if (stalker instanceof VoidStalkerEntity) {
            radius = (Integer)Config.RENDER_RADIUS_SPECIAL.get();
        }
        if ((cached = CHUNK_CACHE.get(cacheKey = center.x + "," + center.z + "," + radius)) != null) {
            return cached;
        }
        int expectedSize = (radius * 2 + 1) * (radius * 2 + 1);
        HashSet<ChunkPos> newChunks = new HashSet<ChunkPos>(expectedSize);
        int radiusSquared = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int distanceSquared = x * x + z * z;
                if (distanceSquared > radiusSquared && radius >= 5) continue;
                newChunks.add(StalkerUtil.getCachedChunkPos(center.x + x, center.z + z));
            }
        }
        Set<ChunkPos> immutableChunks = Collections.unmodifiableSet(newChunks);
        CHUNK_CACHE.put(cacheKey, immutableChunks);
        StalkerUtil.cleanupChunkCache();
        return immutableChunks;
    }

    private static ChunkPos getCachedChunkPos(int x, int z) {
        long key = ChunkPos.asLong((int)x, (int)z);
        return CHUNK_POS_CACHE.computeIfAbsent(key, k -> new ChunkPos(x, z));
    }

    private static void cleanupChunkCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastChunkCacheCleanup > 5000L) {
            CHUNK_CACHE.clear();
            if (CHUNK_POS_CACHE.size() > 10000) {
                CHUNK_POS_CACHE.clear();
            }
            lastChunkCacheCleanup = currentTime;
        }
    }

    public static ArrayList<ChunkPos> getToLoadChunksAsList(Entity stalker, int offset) {
        Set<ChunkPos> chunks = StalkerUtil.getToLoadChunks(stalker, offset);
        if (chunks.isEmpty()) {
            return new ArrayList<ChunkPos>();
        }
        ArrayList<ChunkPos> result = ObjectPool.getChunkPosList();
        result.addAll(chunks);
        return result;
    }
}

