/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.jackson.RecipeScreen;
import net.jackson.RecipeViewerConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemListOverlay {
    private static final int ITEM_SIZE = 16;
    private static final int PADDING = 4;
    private static final Set<class_1792> EXCLUDED_ITEMS = Set.of(class_1802.field_8162);
    private static final List<class_1799> ALL_ITEMS = new ArrayList<class_1799>();
    private static final List<class_1799> FILTERED_ITEMS = new ArrayList<class_1799>();
    private static final Map<class_768, class_1792> clickableAreas = new HashMap<class_768, class_1792>();
    private static int currentPage = 0;
    private static int totalPages = 1;

    public static void reloadItems() {
        ALL_ITEMS.clear();
        FILTERED_ITEMS.clear();
        for (class_1792 item : class_7923.field_41178) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            class_1799 stack2 = new class_1799((class_1935)item);
            if (stack2.method_7960() || EXCLUDED_ITEMS.contains(item)) continue;
            ALL_ITEMS.add(stack2);
            if (RecipeViewerConfig.getInstance().showOnlyCraftable && !ItemListOverlay.hasCraftingRecipe(id)) continue;
            FILTERED_ITEMS.add(stack2);
        }
        ALL_ITEMS.sort(Comparator.comparing(stack -> stack.method_7964().getString()));
        FILTERED_ITEMS.sort(Comparator.comparing(stack -> stack.method_7964().getString()));
    }

    private static boolean hasCraftingRecipe(class_2960 id) {
        String path = id.method_12832();
        if (path.contains("spawn_egg") || path.contains("air") || path.contains("debug") || path.contains("structure_block") || path.contains("jigsaw") || path.contains("barrier") || path.contains("command_block") || path.contains("piston_head") || path.contains("knowledge_book") || path.contains("light")) {
            return false;
        }
        Path recipePath = FabricLoader.getInstance().getGameDir().resolve("resources/assets/jackson/recipes/" + path + ".json");
        return Files.exists(recipePath, new LinkOption[0]);
    }

    public static void render(class_332 context, int mouseX, int mouseY) {
        clickableAreas.clear();
        class_310 client = class_310.method_1551();
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        List<class_1799> itemsToShow = config.showOnlyCraftable ? FILTERED_ITEMS : ALL_ITEMS;
        int itemsPerPage = config.itemsPerRow * config.rowsPerPage;
        totalPages = Math.max(1, (itemsToShow.size() + itemsPerPage - 1) / itemsPerPage);
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int startX = screenWidth - config.itemsPerRow * 20 - 10;
        int startY = 20;
        int bgWidth = config.itemsPerRow * 20 + 10;
        int bgHeight = config.rowsPerPage * 20 + 30;
        context.method_25294(startX - 5, startY - 5, startX + bgWidth, startY + bgHeight, -2013265920);
        int indexStart = currentPage * itemsPerPage;
        List visibleItems = itemsToShow.stream().skip(indexStart).limit(itemsPerPage).toList();
        class_1792 hoveredItem = null;
        int row = 0;
        int col = 0;
        for (class_1799 stack : visibleItems) {
            class_1792 item = stack.method_7909();
            int drawX = startX + col * 20;
            int drawY = startY + row * 20;
            class_768 rect = new class_768(drawX, drawY, 16, 16);
            clickableAreas.put(rect, item);
            if (mouseX >= drawX && mouseX <= drawX + 16 && mouseY >= drawY && mouseY <= drawY + 16) {
                context.method_25294(drawX - 1, drawY - 1, drawX + 16 + 1, drawY + 16 + 1, -1996488705);
                hoveredItem = item;
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_51427(stack, drawX, drawY);
            context.method_51448().method_22909();
            if (++col < config.itemsPerRow) continue;
            col = 0;
            ++row;
        }
        int toggleX = startX;
        int toggleY = startY + config.rowsPerPage * 20 + 5;
        String toggleText = config.showOnlyCraftable ? "Show All" : "Craftables Only";
        int toggleWidth = client.field_1772.method_1727(toggleText) + 8;
        boolean toggleHovered = mouseX >= toggleX && mouseX <= toggleX + toggleWidth && mouseY >= toggleY && mouseY <= toggleY + 12;
        context.method_25294(toggleX, toggleY, toggleX + toggleWidth, toggleY + 12, toggleHovered ? -1 : -10066330);
        context.method_51433(client.field_1772, toggleText, toggleX + 4, toggleY + 2, toggleHovered ? 0 : 0xFFFFFF, false);
        context.method_51433(client.field_1772, "Page " + (currentPage + 1) + " / " + totalPages, startX, toggleY + 15, 0xFFFFFF, false);
        if (hoveredItem != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            class_1799 stack = new class_1799((class_1935)hoveredItem);
            context.method_51434(client.field_1772, List.of(stack.method_7964()), mouseX, mouseY);
            context.method_51448().method_22909();
        }
    }

    public static boolean handleClick(double mouseX, double mouseY) {
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        int toggleX = class_310.method_1551().method_22683().method_4486() - config.itemsPerRow * 20 - 10;
        int toggleY = 20 + config.rowsPerPage * 20 + 5;
        String toggleText = config.showOnlyCraftable ? "Show All" : "Craftables Only";
        int toggleWidth = class_310.method_1551().field_1772.method_1727(toggleText) + 8;
        if (mouseX >= (double)toggleX && mouseX <= (double)(toggleX + toggleWidth) && mouseY >= (double)toggleY && mouseY <= (double)(toggleY + 12)) {
            config.toggleShowOnlyCraftable();
            ItemListOverlay.reloadItems();
            return true;
        }
        for (Map.Entry<class_768, class_1792> entry : clickableAreas.entrySet()) {
            class_768 rect = entry.getKey();
            if (!(mouseX >= (double)rect.method_3321()) || !(mouseX <= (double)(rect.method_3321() + rect.method_3319())) || !(mouseY >= (double)rect.method_3322()) || !(mouseY <= (double)(rect.method_3322() + rect.method_3320()))) continue;
            class_310.method_1551().method_1507((class_437)new RecipeScreen(entry.getValue()));
            return true;
        }
        return false;
    }

    public static boolean handleScroll(double amount) {
        if (amount > 0.0 && currentPage > 0) {
            --currentPage;
            return true;
        }
        if (amount < 0.0 && currentPage < totalPages - 1) {
            ++currentPage;
            return true;
        }
        return false;
    }
}

