/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.RecipeViewerConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class RecipeScreen
extends class_437 {
    private final class_1792 targetItem;
    private JsonObject recipe;
    private class_342 searchField;
    private class_4185 craftableToggleButton;
    private List<class_1792> allItems;
    private List<class_1792> filteredItems;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int ingredientCycleIndex = 0;
    private long lastCycleTime = 0L;
    private static final long CYCLE_INTERVAL_MS = 1000L;
    private static final int SLOT_SIZE = 18;
    private static final int ITEM_LIST_WIDTH = 160;
    private static final int RECIPE_AREA_WIDTH = 200;
    private static final int MARGIN = 10;

    public RecipeScreen(class_1792 item) {
        super((class_2561)class_2561.method_43470((String)"Recipe Viewer"));
        this.targetItem = item;
        this.loadRecipe();
        this.initializeItemList();
    }

    private void initializeItemList() {
        this.allItems = new ArrayList<class_1792>();
        for (class_1792 item : class_7923.field_41178) {
            if (item == class_1802.field_8162) continue;
            this.allItems.add(item);
        }
        this.updateFilteredItems();
    }

    private void updateFilteredItems() {
        List<Object> baseList = this.allItems;
        if (RecipeViewerConfig.getInstance().showOnlyCraftable) {
            baseList = this.allItems.stream().filter(this::hasRecipe).collect(Collectors.toList());
        }
        String searchText = this.searchField != null ? this.searchField.method_1882().toLowerCase() : "";
        this.filteredItems = searchText.isEmpty() ? new ArrayList<Object>(baseList) : baseList.stream().filter(item -> {
            String itemName = class_7923.field_41178.method_10221(item).method_12832().toLowerCase();
            return itemName.contains(searchText);
        }).collect(Collectors.toList());
        this.scrollOffset = 0;
        this.updateMaxScroll();
    }

    private boolean hasRecipe(class_1792 item) {
        boolean bl;
        String itemName = class_7923.field_41178.method_10221((Object)item).method_12832();
        class_2960 file = class_2960.method_60655((String)"jackson", (String)("recipes/" + itemName + ".json"));
        InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("assets/" + file.method_12836() + "/" + file.method_12832())));
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    protected void method_25426() {
        super.method_25426();
        this.searchField = new class_342(this.field_22793, 10, 10, 140, 20, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search items..."));
        this.searchField.method_1863(this::onSearchChanged);
        this.method_25429((class_364)this.searchField);
        this.craftableToggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(RecipeViewerConfig.getInstance().showOnlyCraftable ? "All Items" : "Craftable Only")), button -> {
            RecipeViewerConfig.getInstance().toggleShowOnlyCraftable();
            button.method_25355((class_2561)class_2561.method_43470((String)(RecipeViewerConfig.getInstance().showOnlyCraftable ? "All Items" : "Craftable Only")));
            this.updateFilteredItems();
        }).method_46434(10, 35, 140, 20).method_46431();
        this.method_37063((class_364)this.craftableToggleButton);
        this.updateMaxScroll();
    }

    private void onSearchChanged(String search) {
        this.updateFilteredItems();
    }

    private void updateMaxScroll() {
        int itemsPerRow = 8;
        int visibleRows = (this.field_22790 - 105) / 18;
        int totalRows = (this.filteredItems.size() + itemsPerRow - 1) / itemsPerRow;
        this.maxScroll = Math.max(0, totalRows - visibleRows);
    }

    private void loadRecipe() {
        String itemName = class_7923.field_41178.method_10221((Object)this.targetItem).method_12832();
        class_2960 file = class_2960.method_60655((String)"jackson", (String)("recipes/" + itemName + ".json"));
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("assets/" + file.method_12836() + "/" + file.method_12832())));){
            this.recipe = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Exception e) {
            System.err.println("Failed to load recipe for " + itemName);
            this.recipe = null;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, 160, this.field_22790, -2013265920);
        context.method_25294(160, 0, this.field_22789, this.field_22790, 0x44000000);
        super.method_25394(context, mouseX, mouseY, delta);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        this.renderItemList(context, mouseX, mouseY);
        this.renderRecipeArea(context, mouseX, mouseY);
    }

    private void renderItemList(class_332 context, int mouseX, int mouseY) {
        int startY = 65;
        int itemsPerRow = 8;
        int x = 10;
        int y = startY;
        int row = 0;
        int col = 0;
        for (int i = this.scrollOffset * itemsPerRow; i < this.filteredItems.size() && row < (this.field_22790 - startY) / 18; ++i) {
            class_1792 item = this.filteredItems.get(i);
            this.drawSlot(context, x + col * 18, y + row * 18, item == this.targetItem);
            context.method_51427(new class_1799((class_1935)item), x + col * 18 + 1, y + row * 18 + 1);
            if (mouseX >= x + col * 18 && mouseX < x + (col + 1) * 18 && mouseY >= y + row * 18 && mouseY < y + (row + 1) * 18) {
                context.method_25294(x + col * 18, y + row * 18, x + (col + 1) * 18, y + (row + 1) * 18, -2130706433);
            }
            if (++col < itemsPerRow) continue;
            col = 0;
            ++row;
        }
    }

    private void renderRecipeArea(class_332 context, int mouseX, int mouseY) {
        String type;
        int recipeX = 170;
        int recipeY = 40;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("Recipe: " + class_7923.field_41178.method_10221((Object)this.targetItem).method_12832())), 260, 20, 0xFFFFFF);
        if (this.recipe == null) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No recipe found"), 260, recipeY + 50, 0xFF0000);
            return;
        }
        switch (type = this.recipe.get("type").getAsString()) {
            case "minecraft:crafting_shaped": {
                this.renderShapedCrafting(context, this.recipe, recipeX, recipeY);
                break;
            }
            case "minecraft:crafting_shapeless": {
                this.renderShapelessCrafting(context, this.recipe, recipeX, recipeY);
                break;
            }
            case "minecraft:blasting": 
            case "minecraft:smelting": {
                this.renderCooking(context, this.recipe, type, recipeX, recipeY);
                break;
            }
            case "minecraft:smithing_transform": {
                this.renderSmithing(context, this.recipe, recipeX, recipeY);
                break;
            }
            default: {
                context.method_25300(this.field_22793, "Unknown recipe type: " + type, 260, recipeY + 50, 0xFF0000);
            }
        }
    }

    private void renderShapedCrafting(class_332 context, JsonObject json, int startX, int startY) {
        int row;
        JsonArray pattern = json.getAsJsonArray("pattern");
        JsonObject key = json.getAsJsonObject("key");
        JsonObject result = json.getAsJsonObject("result");
        HashMap<Character, class_1799> keyMap = new HashMap<Character, class_1799>();
        for (Map.Entry entry : key.entrySet()) {
            char symbol = ((String)entry.getKey()).charAt(0);
            String id = ((JsonElement)entry.getValue()).getAsString();
            class_1792 item = this.resolveItemFromIdOrTag(id);
            keyMap.put(Character.valueOf(symbol), new class_1799((class_1935)item));
        }
        int gridSize = 3;
        for (row = 0; row < gridSize; ++row) {
            for (int col = 0; col < gridSize; ++col) {
                this.drawSlot(context, startX + col * 20, startY + row * 20, false);
            }
        }
        for (row = 0; row < pattern.size() && row < gridSize; ++row) {
            String line = pattern.get(row).getAsString();
            for (int col = 0; col < line.length() && col < gridSize; ++col) {
                class_1799 stack;
                char symbol = line.charAt(col);
                if (symbol == ' ' || (stack = keyMap.getOrDefault(Character.valueOf(symbol), class_1799.field_8037)).method_7960()) continue;
                context.method_51427(stack, startX + col * 20 + 1, startY + row * 20 + 1);
            }
        }
        context.method_25290(class_1921::method_62277, class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/crafting_table.png"), startX + 70, startY + 20, 89.0f, 15.0f, 22, 15, 256, 256);
        this.drawSlot(context, startX + 100, startY + 20, false);
        int count = result.has("count") ? result.get("count").getAsInt() : 1;
        class_1799 resultStack = new class_1799((class_1935)this.resolveItemFromIdOrTag(result.get("id").getAsString()), count);
        context.method_51427(resultStack, startX + 101, startY + 21);
        if (count > 1) {
            String countText = String.valueOf(count);
            int textX = startX + 101 + 16 - this.field_22793.method_1727(countText);
            int textY = startY + 21 + 6;
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_51433(this.field_22793, countText, textX, textY, 0xFFFFFF, true);
            context.method_51448().method_22909();
        }
    }

    private void renderShapelessCrafting(class_332 context, JsonObject json, int startX, int startY) {
        ArrayList<String> ingredientIds = new ArrayList<String>();
        if (json.has("ingredients")) {
            JsonArray ingredients = json.getAsJsonArray("ingredients");
            for (JsonElement el : ingredients) {
                ingredientIds.add(el.getAsString());
            }
        } else if (json.has("ingredient")) {
            JsonElement ing = json.get("ingredient");
            if (ing.isJsonArray()) {
                for (JsonElement el : ing.getAsJsonArray()) {
                    ingredientIds.add(el.getAsString());
                }
            } else if (ing.isJsonPrimitive()) {
                ingredientIds.add(ing.getAsString());
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.drawSlot(context, startX + col * 20, startY + row * 20, false);
            }
        }
        for (int i = 0; i < ingredientIds.size() && i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            String id = (String)ingredientIds.get(i);
            class_1792 item = this.resolveItemFromIdOrTag(id);
            context.method_51427(new class_1799((class_1935)item), startX + col * 20 + 1, startY + row * 20 + 1);
        }
        context.method_25290(class_1921::method_62277, class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/crafting_table.png"), startX + 70, startY + 20, 89.0f, 15.0f, 22, 15, 256, 256);
        JsonObject result = json.getAsJsonObject("result");
        this.drawSlot(context, startX + 100, startY + 20, false);
        int count = result.has("count") ? result.get("count").getAsInt() : 1;
        class_1799 resultStack = new class_1799((class_1935)this.resolveItemFromIdOrTag(result.get("id").getAsString()), count);
        context.method_51427(resultStack, startX + 101, startY + 21);
        if (count > 1) {
            String countText = String.valueOf(count);
            int textX = startX + 101 + 16 - this.field_22793.method_1727(countText);
            Objects.requireNonNull(this.field_22793);
            int textY = startY + 21 + 16 - 9;
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_51433(this.field_22793, countText, textX, textY, 0xFFFFFF, true);
            context.method_51448().method_22909();
        }
    }

    private void renderCooking(class_332 context, JsonObject json, String type, int startX, int startY) {
        ArrayList<String> ingredientIds = new ArrayList<String>();
        if (json.get("ingredient").isJsonArray()) {
            JsonArray arr = json.getAsJsonArray("ingredient");
            for (JsonElement el : arr) {
                ingredientIds.add(el.getAsString());
            }
        } else if (json.get("ingredient").isJsonPrimitive()) {
            ingredientIds.add(json.get("ingredient").getAsString());
        }
        if (ingredientIds.size() > 1) {
            long now = System.currentTimeMillis();
            if (now - this.lastCycleTime > 1000L) {
                this.ingredientCycleIndex = (this.ingredientCycleIndex + 1) % ingredientIds.size();
                this.lastCycleTime = now;
            }
        } else {
            this.ingredientCycleIndex = 0;
        }
        this.drawSlot(context, startX, startY, false);
        this.drawSlot(context, startX, startY + 40, false);
        this.drawSlot(context, startX + 80, startY + 20, false);
        if (!ingredientIds.isEmpty()) {
            String id = (String)ingredientIds.get(this.ingredientCycleIndex);
            class_1792 item = this.resolveItemFromIdOrTag(id);
            context.method_51427(new class_1799((class_1935)item), startX + 1, startY + 1);
        }
        context.method_51427(new class_1799((class_1935)class_1802.field_8713), startX + 1, startY + 41);
        context.method_25290(class_1921::method_62277, class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/furnace.png"), startX + 30, startY + 20, 79.0f, 34.0f, 24, 17, 256, 256);
        int cookingTime = json.has("cookingtime") ? json.get("cookingtime").getAsInt() : 200;
        float experience = json.has("experience") ? json.get("experience").getAsFloat() : 0.0f;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)("Time: " + (float)cookingTime / 20.0f + "s")), startX, startY + 70, 699050);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)("XP: " + experience)), startX, startY + 85, 699050);
        JsonObject result = json.getAsJsonObject("result");
        int count = result.has("count") ? result.get("count").getAsInt() : 1;
        class_1799 resultStack = new class_1799((class_1935)this.resolveItemFromIdOrTag(result.get("id").getAsString()), count);
        context.method_51427(resultStack, startX + 81, startY + 21);
        if (count > 1) {
            String countText = String.valueOf(count);
            int textX = startX + 81 + 16 - this.field_22793.method_1727(countText);
            Objects.requireNonNull(this.field_22793);
            int textY = startY + 21 + 16 - 9;
            context.method_51433(this.field_22793, countText, textX, textY, 0xFFFFFF, true);
        }
    }

    private void renderSmithing(class_332 context, JsonObject json, int startX, int startY) {
        this.drawSlot(context, startX, startY, false);
        this.drawSlot(context, startX + 25, startY, false);
        this.drawSlot(context, startX + 50, startY, false);
        this.drawSlot(context, startX + 100, startY, false);
        if (json.has("template")) {
            class_1792 template = this.resolveItemFromIdOrTag(json.get("template").getAsString());
            context.method_51427(new class_1799((class_1935)template), startX + 1, startY + 1);
        }
        if (json.has("base")) {
            class_1792 base = this.resolveItemFromIdOrTag(json.get("base").getAsString());
            context.method_51427(new class_1799((class_1935)base), startX + 26, startY + 1);
        }
        if (json.has("addition")) {
            class_1792 addition = this.resolveItemFromIdOrTag(json.get("addition").getAsString());
            context.method_51427(new class_1799((class_1935)addition), startX + 51, startY + 1);
        }
        context.method_25290(class_1921::method_62277, class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/smithing.png"), startX + 75, startY, 44.0f, 15.0f, 20, 15, 256, 256);
        JsonObject result = json.getAsJsonObject("result");
        int count = result.has("count") ? result.get("count").getAsInt() : 1;
        class_1799 resultStack = new class_1799((class_1935)this.resolveItemFromIdOrTag(result.get("id").getAsString()), count);
        context.method_51427(resultStack, startX + 101, startY + 1);
        if (count > 1) {
            String countText = String.valueOf(count);
            int textX = startX + 101 + 16 - this.field_22793.method_1727(countText);
            Objects.requireNonNull(this.field_22793);
            int textY = startY + 1 + 16 - 9;
            context.method_51433(this.field_22793, countText, textX, textY, 0xFFFFFF, true);
        }
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Template"), startX, startY + 25, 699050);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Base"), startX + 25, startY + 25, 699050);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Addition"), startX + 50, startY + 25, 699050);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Result"), startX + 100, startY + 25, 699050);
    }

    private void drawSlot(class_332 context, int x, int y, boolean selected) {
        int color = selected ? -1 : -7631989;
        context.method_25294(x - 1, y - 1, x + 18 + 1, y + 18 + 1, color);
        context.method_25294(x, y, x + 18, y + 18, -13158601);
    }

    private class_1792 resolveItemFromIdOrTag(String idOrTag) {
        if (idOrTag.startsWith("#")) {
            return this.getRepresentativeItemFromTag(idOrTag);
        }
        String cleanId = idOrTag.startsWith("#") ? idOrTag.substring(1) : idOrTag;
        try {
            return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)cleanId));
        }
        catch (Exception e) {
            System.err.println("Failed to parse item ID: " + cleanId);
            return class_1802.field_8077;
        }
    }

    private class_1792 getRepresentativeItemFromTag(String tag) {
        switch (tag) {
            case "#minecraft:planks": {
                return class_1802.field_8118;
            }
            case "#minecraft:logs": 
            case "#minecraft:logs_that_burn": {
                return class_1802.field_8583;
            }
            case "#minecraft:acacia_logs": {
                return class_1802.field_8820;
            }
            case "#minecraft:birch_logs": {
                return class_1802.field_8170;
            }
            case "#minecraft:cherry_logs": {
                return class_1802.field_42692;
            }
            case "#minecraft:dark_oak_logs": {
                return class_1802.field_8652;
            }
            case "#minecraft:jungle_logs": {
                return class_1802.field_8125;
            }
            case "#minecraft:mangrove_logs": {
                return class_1802.field_37512;
            }
            case "#minecraft:oak_logs": {
                return class_1802.field_8583;
            }
            case "#minecraft:spruce_logs": {
                return class_1802.field_8684;
            }
            case "#minecraft:stone_crafting_materials": {
                return class_1802.field_20412;
            }
            case "#minecraft:coals": {
                return class_1802.field_8713;
            }
            case "#minecraft:wooden_slabs": {
                return class_1802.field_8320;
            }
            case "#minecraft:bundles": {
                return class_1802.field_27023;
            }
            case "#minecraft:shulker_boxes": {
                return class_1802.field_8545;
            }
            case "#minecraft:trim_materials": {
                return class_1802.field_8620;
            }
            case "#minecraft:trimmable_armor": {
                return class_1802.field_8523;
            }
            case "#minecraft:netherite_tool_materials": {
                return class_1802.field_22020;
            }
            case "#minecraft:crimson_stems": {
                return class_1802.field_21981;
            }
        }
        String cleanTag = tag.replace("#minecraft:", "");
        if (cleanTag.endsWith("_logs")) {
            String logType = cleanTag.replace("_logs", "_log");
            try {
                return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)logType));
            }
            catch (Exception e) {
                System.err.println("Unknown tag: " + tag + ", could not resolve to " + logType + ", using oak log as fallback");
                return class_1802.field_8583;
            }
        }
        System.err.println("Unknown tag: " + tag + ", using barrier as fallback");
        return class_1802.field_8077;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.searchField.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX < 160.0 && mouseY > 65.0) {
            int index;
            int startY = 65;
            int itemsPerRow = 8;
            int col = (int)((mouseX - 10.0) / 18.0);
            int row = (int)((mouseY - (double)startY) / 18.0) + this.scrollOffset;
            if (col >= 0 && col < itemsPerRow && (index = row * itemsPerRow + col) >= 0 && index < this.filteredItems.size()) {
                class_1792 clickedItem = this.filteredItems.get(index);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new RecipeScreen(clickedItem));
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX < 160.0) {
            this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)verticalAmount), (int)0, (int)this.maxScroll);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25410(class_310 client, int width, int height) {
        String searchText = this.searchField.method_1882();
        super.method_25410(client, width, height);
        this.method_25426();
        this.searchField.method_1852(searchText);
    }

    public boolean method_25421() {
        return false;
    }
}

