/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class Config {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("lessthanenoughitems.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean hideNonCraftables = false;
    public int itemsPerRow = 15;
    public int rowsPerPage = 20;
    private static Config instance;

    public static Config getInstance() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    private static Config load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (Config)GSON.fromJson(json, Config.class);
            }
            catch (Exception e) {
                System.err.println("Failed to load config, using defaults: " + e.getMessage());
            }
        }
        return new Config();
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }
}

