/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.RecipeScreen;
import net.jackson.RecipeViewerConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemListOverlay {
    private static final int ITEM_SIZE = 16;
    private static final int PADDING = 4;
    private static final Set<class_1792> EXCLUDED_ITEMS = Set.of(class_1802.field_8162);
    private static final List<class_1799> ALL_ITEMS = new ArrayList<class_1799>();
    private static final List<class_1799> FILTERED_ITEMS = new ArrayList<class_1799>();
    private static final Set<String> CRAFTABLE_ITEMS = new HashSet<String>();
    private static class_342 searchField;
    private static String lastSearchText;
    private static boolean searchFieldInitialized;
    private static long lastFilterUpdateTime;
    private static final long FILTER_DEBOUNCE_MS = 150L;
    private static final Map<class_768, class_1792> clickableAreas;
    private static int currentPage;
    private static int totalPages;

    public static void reloadItems() {
        ALL_ITEMS.clear();
        FILTERED_ITEMS.clear();
        ItemListOverlay.loadCraftableItems();
        for (class_1792 item : class_7923.field_41178) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            class_1799 stack2 = new class_1799((class_1935)item);
            if (stack2.method_7960() || EXCLUDED_ITEMS.contains(item)) continue;
            ALL_ITEMS.add(stack2);
        }
        ALL_ITEMS.sort(Comparator.comparing(stack -> stack.method_7964().getString()));
        ItemListOverlay.updateFilteredItems();
    }

    private static void loadCraftableItems() {
        CRAFTABLE_ITEMS.clear();
        try {
            String[] recipeTypes;
            for (String type : recipeTypes = new String[]{"recipes", "smelting", "blasting"}) {
                try (InputStream stream = ItemListOverlay.class.getClassLoader().getResourceAsStream("assets/jackson/" + type);){
                    if (stream == null) continue;
                    ItemListOverlay.populateCommonCraftableItems();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            ItemListOverlay.populateCommonCraftableItems();
        }
    }

    private static void populateCommonCraftableItems() {
        String[] commonCraftable;
        for (String itemName : commonCraftable = new String[]{"oak_planks", "spruce_planks", "birch_planks", "jungle_planks", "acacia_planks", "dark_oak_planks", "stick", "crafting_table", "furnace", "chest", "ladder", "torch", "stone_pickaxe", "stone_axe", "stone_shovel", "stone_sword", "stone_hoe", "iron_pickaxe", "iron_axe", "iron_shovel", "iron_sword", "iron_hoe", "diamond_pickaxe", "diamond_axe", "diamond_shovel", "diamond_sword", "diamond_hoe", "wooden_pickaxe", "wooden_axe", "wooden_shovel", "wooden_sword", "wooden_hoe", "bread", "cake", "cookie", "glass", "iron_ingot", "gold_ingot", "diamond", "emerald", "coal", "charcoal"}) {
            CRAFTABLE_ITEMS.add(itemName);
        }
    }

    private static boolean hasCraftingRecipe(class_2960 id) {
        String path = id.method_12832();
        if (CRAFTABLE_ITEMS.contains(path)) {
            return true;
        }
        if (path.contains("spawn_egg") || path.contains("air") || path.contains("debug") || path.contains("structure_block") || path.contains("jigsaw") || path.contains("barrier") || path.contains("command_block") || path.contains("piston_head") || path.contains("knowledge_book") || path.contains("light")) {
            return false;
        }
        return ItemListOverlay.checkRecipeExists(path);
    }

    private static boolean checkRecipeExists(String itemName) {
        try {
            InputStream stream = ItemListOverlay.class.getClassLoader().getResourceAsStream("assets/jackson/recipes/" + itemName + ".json");
            if (stream != null) {
                stream.close();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void updateFilteredItems() {
        String searchText;
        List<Object> baseItems = new ArrayList<class_1799>(ALL_ITEMS);
        if (RecipeViewerConfig.getInstance().showOnlyCraftable) {
            baseItems = baseItems.stream().filter(stack -> ItemListOverlay.hasCraftingRecipe(class_7923.field_41178.method_10221((Object)stack.method_7909()))).collect(Collectors.toList());
        }
        if (!(searchText = (searchField != null ? searchField.method_1882() : "").toLowerCase().trim()).isEmpty()) {
            baseItems = baseItems.stream().filter(stack -> {
                String itemName = stack.method_7964().getString().toLowerCase();
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().toLowerCase();
                return itemName.contains(searchText) || itemId.contains(searchText);
            }).collect(Collectors.toList());
        }
        FILTERED_ITEMS.clear();
        FILTERED_ITEMS.addAll(baseItems);
    }

    private static void initializeSearchField() {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        int overlayWidth = config.itemsPerRow * 20 + 10;
        int startX = screenWidth - overlayWidth - 10;
        searchField = new class_342(client.field_1772, startX, 5, overlayWidth - 5, 16, (class_2561)class_2561.method_43470((String)"Search..."));
        searchField.method_47404((class_2561)class_2561.method_43470((String)"Search items..."));
        searchField.method_1852(lastSearchText);
        searchField.method_1863(text -> {
            lastSearchText = text;
            ItemListOverlay.scheduleFilterUpdate();
        });
        searchField.method_1856(true);
        searchField.method_1888(true);
        searchFieldInitialized = true;
    }

    private static void scheduleFilterUpdate() {
        lastFilterUpdateTime = System.currentTimeMillis();
        new Thread(() -> {
            try {
                Thread.sleep(150L);
                if (System.currentTimeMillis() - lastFilterUpdateTime >= 150L) {
                    class_310.method_1551().execute(() -> ItemListOverlay.updateFilteredItems());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void render(class_332 context, int mouseX, int mouseY) {
        searchFieldInitialized = false;
        ItemListOverlay.initializeSearchField();
        clickableAreas.clear();
        class_310 client = class_310.method_1551();
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        List<class_1799> itemsToShow = FILTERED_ITEMS;
        int itemsPerPage = config.itemsPerRow * config.rowsPerPage;
        totalPages = Math.max(1, (itemsToShow.size() + itemsPerPage - 1) / itemsPerPage);
        int screenWidth = client.method_22683().method_4486();
        int startX = screenWidth - config.itemsPerRow * 20 - 10;
        int startY = 25;
        int bgWidth = config.itemsPerRow * 20 + 10;
        int bgHeight = config.rowsPerPage * 20 + 45;
        context.method_25294(startX - 5, 2, startX + bgWidth, startY + bgHeight, -2013265920);
        if (searchField != null) {
            int searchX = searchField.method_46426();
            int searchY = searchField.method_46427();
            int searchWidth = searchField.method_25368();
            int searchHeight = searchField.method_25364();
            boolean searchHovered = mouseX >= searchX && mouseX <= searchX + searchWidth && mouseY >= searchY && mouseY <= searchY + searchHeight;
            boolean searchFocused = searchField.method_25370();
            context.method_25294(searchX - 1, searchY - 1, searchX + searchWidth + 1, searchY + searchHeight + 1, searchFocused ? -1 : (searchHovered ? -3355444 : -6710887));
            context.method_25294(searchX, searchY, searchX + searchWidth, searchY + searchHeight, -16777216);
            searchField.method_25394(context, mouseX, mouseY, 0.0f);
            if (searchFocused) {
                context.method_25294(searchX - 2, searchY - 2, searchX + searchWidth + 2, searchY + searchHeight + 2, 855681791);
            }
        }
        int indexStart = currentPage * itemsPerPage;
        List visibleItems = itemsToShow.stream().skip(indexStart).limit(itemsPerPage).toList();
        class_1792 hoveredItem = null;
        int row = 0;
        int col = 0;
        for (class_1799 stack : visibleItems) {
            class_1792 item = stack.method_7909();
            int drawX = startX + col * 20;
            int drawY = startY + row * 20;
            class_768 rect = new class_768(drawX, drawY, 16, 16);
            clickableAreas.put(rect, item);
            if (mouseX >= drawX && mouseX <= drawX + 16 && mouseY >= drawY && mouseY <= drawY + 16) {
                context.method_25294(drawX - 1, drawY - 1, drawX + 16 + 1, drawY + 16 + 1, -1996488705);
                hoveredItem = item;
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_51427(stack, drawX, drawY);
            context.method_51448().method_22909();
            if (++col < config.itemsPerRow) continue;
            col = 0;
            ++row;
        }
        int screenWidthForButton = client.method_22683().method_4486();
        int buttonStartX = screenWidthForButton - config.itemsPerRow * 20 - 10;
        int toggleY = startY + config.rowsPerPage * 20 + 5;
        String toggleText = config.showOnlyCraftable ? "Show All" : "Craftables Only";
        int toggleWidth = client.field_1772.method_1727(toggleText) + 8;
        boolean toggleHovered = mouseX >= buttonStartX && mouseX <= buttonStartX + toggleWidth && mouseY >= toggleY && mouseY <= toggleY + 12;
        context.method_25294(buttonStartX, toggleY, buttonStartX + toggleWidth, toggleY + 12, toggleHovered ? -1 : -10066330);
        context.method_51433(client.field_1772, toggleText, buttonStartX + 4, toggleY + 2, toggleHovered ? 0 : 0xFFFFFF, false);
        context.method_51433(client.field_1772, "Page " + (currentPage + 1) + " / " + totalPages, buttonStartX, toggleY + 15, 0xFFFFFF, false);
        if (hoveredItem != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            class_1799 stack = new class_1799((class_1935)hoveredItem);
            context.method_51434(client.field_1772, List.of(stack.method_7964()), mouseX, mouseY);
            context.method_51448().method_22909();
        }
    }

    public static boolean handleClick(double mouseX, double mouseY) {
        if (searchField != null && searchField.method_25402(mouseX, mouseY, 0)) {
            return true;
        }
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int buttonStartX = screenWidth - config.itemsPerRow * 20 - 10;
        int toggleY = 25 + config.rowsPerPage * 20 + 5;
        String toggleText = config.showOnlyCraftable ? "Show All" : "Craftables Only";
        int toggleWidth = class_310.method_1551().field_1772.method_1727(toggleText) + 8;
        if (mouseX >= (double)buttonStartX && mouseX <= (double)(buttonStartX + toggleWidth) && mouseY >= (double)toggleY && mouseY <= (double)(toggleY + 12)) {
            config.toggleShowOnlyCraftable();
            ItemListOverlay.updateFilteredItems();
            return true;
        }
        for (Map.Entry<class_768, class_1792> entry : clickableAreas.entrySet()) {
            class_768 rect = entry.getKey();
            if (!(mouseX >= (double)rect.method_3321()) || !(mouseX <= (double)(rect.method_3321() + rect.method_3319())) || !(mouseY >= (double)rect.method_3322()) || !(mouseY <= (double)(rect.method_3322() + rect.method_3320()))) continue;
            class_310.method_1551().method_1507((class_437)new RecipeScreen(entry.getValue()));
            return true;
        }
        return false;
    }

    public static boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (searchField != null) {
            boolean handled = searchField.method_25404(keyCode, scanCode, modifiers);
            if (handled) {
                return true;
            }
            if (keyCode == 259) {
                String currentText = searchField.method_1882();
                if (!currentText.isEmpty()) {
                    searchField.method_1852(currentText.substring(0, currentText.length() - 1));
                    return true;
                }
            } else if (keyCode == 261) {
                return true;
            }
            if (keyCode >= 32 && keyCode <= 126) {
                char character = (char)keyCode;
                if ((modifiers & 1) != 0) {
                    if (character >= 'a' && character <= 'z') {
                        character = Character.toUpperCase(character);
                    } else if (character >= '0' && character <= '9') {
                        String shiftedSymbols = ")!@#$%^&*(";
                        character = shiftedSymbols.charAt(character - 48);
                    }
                } else if (character >= 'A' && character <= 'Z') {
                    character = Character.toLowerCase(character);
                }
                String currentText = searchField.method_1882();
                String newText = currentText + character;
                searchField.method_1852(newText);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean handleScroll(double amount) {
        if (amount > 0.0 && currentPage > 0) {
            --currentPage;
            return true;
        }
        if (amount < 0.0 && currentPage < totalPages - 1) {
            ++currentPage;
            return true;
        }
        return false;
    }

    static {
        lastSearchText = "";
        searchFieldInitialized = false;
        lastFilterUpdateTime = 0L;
        clickableAreas = new HashMap<class_768, class_1792>();
        currentPage = 0;
        totalPages = 1;
    }
}

