/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.RecipeScreen;
import net.jackson.RecipeViewerConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemListOverlay {
    private static final int ITEM_SIZE = 16;
    private static final int PADDING = 4;
    private static final Set<class_1792> EXCLUDED_ITEMS = Set.of(class_1802.field_8162);
    private static final List<class_1799> ALL_ITEMS = new ArrayList<class_1799>();
    private static final List<class_1799> FILTERED_ITEMS = new ArrayList<class_1799>();
    private static final List<class_1799> CRAFTABLE_ITEMS_CACHE = new ArrayList<class_1799>();
    private static final Set<String> CRAFTABLE_ITEM_IDS = new HashSet<String>();
    public static final Map<String, Boolean> RECIPE_CACHE = new HashMap<String, Boolean>();
    private static boolean isCraftableCacheLoaded = false;
    private static class_342 searchField;
    private static String lastSearchText;
    private static boolean searchFieldInitialized;
    private static boolean searchFieldFocused;
    private static class_437 previousScreen;
    private static long lastFilterUpdateTime;
    private static final long FILTER_DEBOUNCE_MS = 150L;
    private static final Map<class_768, class_1792> clickableAreas;
    private static int currentPage;
    private static int totalPages;

    public static void setPreviousScreen(class_437 screen) {
        previousScreen = screen;
    }

    public static class_437 getPreviousScreen() {
        return previousScreen;
    }

    public static void reloadItems() {
        ALL_ITEMS.clear();
        FILTERED_ITEMS.clear();
        ItemListOverlay.loadCraftableItems();
        for (class_1792 item : class_7923.field_41178) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            class_1799 stack2 = new class_1799((class_1935)item);
            if (stack2.method_7960() || EXCLUDED_ITEMS.contains(item)) continue;
            ALL_ITEMS.add(stack2);
        }
        ALL_ITEMS.sort(Comparator.comparing(stack -> stack.method_7964().getString()));
        ItemListOverlay.updateFilteredItems();
    }

    private static void loadCraftableItems() {
        CRAFTABLE_ITEM_IDS.clear();
        CRAFTABLE_ITEMS_CACHE.clear();
        try {
            String[] recipeTypes;
            for (String type : recipeTypes = new String[]{"recipes", "smelting", "blasting"}) {
                try (InputStream stream = ItemListOverlay.class.getClassLoader().getResourceAsStream("assets/jackson/" + type);){
                    if (stream == null) continue;
                    ItemListOverlay.populateCommonCraftableItems();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            ItemListOverlay.populateCommonCraftableItems();
        }
    }

    private static void populateCommonCraftableItems() {
        String[] commonCraftable;
        for (String itemName : commonCraftable = new String[]{"oak_planks", "spruce_planks", "birch_planks", "jungle_planks", "acacia_planks", "dark_oak_planks", "stick", "crafting_table", "furnace", "chest", "ladder", "torch", "stone_pickaxe", "stone_axe", "stone_shovel", "stone_sword", "stone_hoe", "iron_pickaxe", "iron_axe", "iron_shovel", "iron_sword", "iron_hoe", "diamond_pickaxe", "diamond_axe", "diamond_shovel", "diamond_sword", "diamond_hoe", "wooden_pickaxe", "wooden_axe", "wooden_shovel", "wooden_sword", "wooden_hoe", "bread", "cake", "cookie", "glass", "iron_ingot", "gold_ingot", "diamond", "emerald", "coal", "charcoal"}) {
            CRAFTABLE_ITEM_IDS.add(itemName);
        }
    }

    private static boolean hasCraftingRecipe(class_2960 id) {
        String path = id.method_12832();
        if (CRAFTABLE_ITEM_IDS.contains(path)) {
            return true;
        }
        if (path.contains("spawn_egg") || path.contains("air") || path.contains("debug") || path.contains("structure_block") || path.contains("jigsaw") || path.contains("barrier") || path.contains("command_block") || path.contains("piston_head") || path.contains("knowledge_book") || path.contains("light")) {
            return false;
        }
        return ItemListOverlay.checkRecipeExists(path);
    }

    private static boolean checkRecipeExists(String itemName) {
        if (RECIPE_CACHE.containsKey(itemName)) {
            return RECIPE_CACHE.get(itemName);
        }
        try {
            boolean exists;
            InputStream stream = ItemListOverlay.class.getClassLoader().getResourceAsStream("assets/jackson/recipes/" + itemName + ".json");
            boolean bl = exists = stream != null;
            if (exists) {
                stream.close();
            }
            RECIPE_CACHE.put(itemName, exists);
            return exists;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void updateFilteredItems() {
        List<Object> baseItems;
        if (RecipeViewerConfig.getInstance().showOnlyCraftable) {
            if (isCraftableCacheLoaded) {
                baseItems = new ArrayList<class_1799>(CRAFTABLE_ITEMS_CACHE);
            } else {
                ItemListOverlay.preloadCraftableItems();
                baseItems = ALL_ITEMS.stream().filter(stack -> {
                    String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
                    return CRAFTABLE_ITEM_IDS.contains(itemId) || ItemListOverlay.fastCheckHasRecipe(itemId);
                }).collect(Collectors.toList());
            }
        } else {
            baseItems = new ArrayList<class_1799>(ALL_ITEMS);
        }
        String searchText = (searchField != null ? searchField.method_1882() : "").toLowerCase().trim();
        if (!searchText.isEmpty()) {
            baseItems = baseItems.parallelStream().filter(stack -> {
                String itemName = stack.method_7964().getString().toLowerCase();
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().toLowerCase();
                return itemName.contains(searchText) || itemId.contains(searchText);
            }).collect(Collectors.toList());
        }
        FILTERED_ITEMS.clear();
        FILTERED_ITEMS.addAll(baseItems);
    }

    private static void initializeSearchField() {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        int overlayWidth = config.itemsPerRow * 20 + 10;
        int startX = screenWidth - overlayWidth - 10;
        int searchWidth = overlayWidth - 5;
        searchField = new class_342(client.field_1772, startX + 10, 5, searchWidth, 16, (class_2561)class_2561.method_43470((String)"Search..."));
        searchField.method_47404((class_2561)class_2561.method_43470((String)"Search items..."));
        searchField.method_1852(lastSearchText);
        searchField.method_1863(text -> {
            lastSearchText = text;
            ItemListOverlay.scheduleFilterUpdate();
        });
        searchField.method_1856(true);
        searchField.method_1888(true);
        searchFieldInitialized = true;
    }

    private static void scheduleFilterUpdate() {
        lastFilterUpdateTime = System.currentTimeMillis();
        new Thread(() -> {
            try {
                Thread.sleep(150L);
                if (System.currentTimeMillis() - lastFilterUpdateTime >= 150L) {
                    class_310.method_1551().execute(() -> ItemListOverlay.updateFilteredItems());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void render(class_332 context, int mouseX, int mouseY) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        int overlayWidth = config.itemsPerRow * 20 + 10;
        int expectedX = screenWidth - overlayWidth - 10;
        if (!searchFieldInitialized || searchField == null || searchField.method_46426() != expectedX) {
            boolean wasFocused = searchFieldFocused;
            ItemListOverlay.initializeSearchField();
            if (wasFocused) {
                searchField.method_25365(true);
                searchFieldFocused = true;
            }
        }
        clickableAreas.clear();
        List<class_1799> itemsToShow = FILTERED_ITEMS;
        int itemsPerPage = config.itemsPerRow * config.rowsPerPage;
        totalPages = Math.max(1, (itemsToShow.size() + itemsPerPage - 1) / itemsPerPage);
        int startX = screenWidth - config.itemsPerRow * 20 - 10;
        int startY = 25;
        int bgWidth = config.itemsPerRow * 20 + 10;
        int bgHeight = config.rowsPerPage * 20 + 45;
        context.method_25294(startX - 5, 2, startX + bgWidth, startY + bgHeight, -2013265920);
        if (searchField != null) {
            int searchX = searchField.method_46426();
            int searchY = searchField.method_46427();
            int searchWidth = searchField.method_25368();
            int searchHeight = searchField.method_25364();
            boolean searchHovered = mouseX >= searchX && mouseX <= searchX + searchWidth && mouseY >= searchY && mouseY <= searchY + searchHeight;
            boolean searchFocused = searchField.method_25370();
            context.method_25294(searchX - 1, searchY - 1, searchX + searchWidth + 1, searchY + searchHeight + 1, searchFocused ? -1 : (searchHovered ? -3355444 : -6710887));
            context.method_25294(searchX, searchY, searchX + searchWidth, searchY + searchHeight, -16777216);
            searchField.method_25394(context, mouseX, mouseY, 0.0f);
            if (searchFocused) {
                context.method_25294(searchX - 2, searchY - 2, searchX + searchWidth + 2, searchY + searchHeight + 2, 855681791);
            }
        }
        int indexStart = currentPage * itemsPerPage;
        List visibleItems = itemsToShow.stream().skip(indexStart).limit(itemsPerPage).toList();
        class_1792 hoveredItem = null;
        int row = 0;
        int col = 0;
        for (class_1799 stack : visibleItems) {
            class_1792 item = stack.method_7909();
            int drawX = startX + col * 20;
            int drawY = startY + row * 20;
            class_768 rect = new class_768(drawX, drawY, 16, 16);
            clickableAreas.put(rect, item);
            if (mouseX >= drawX && mouseX <= drawX + 16 && mouseY >= drawY && mouseY <= drawY + 16) {
                context.method_25294(drawX - 1, drawY - 1, drawX + 16 + 1, drawY + 16 + 1, -1996488705);
                hoveredItem = item;
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_51427(stack, drawX, drawY);
            context.method_51448().method_22909();
            if (++col < config.itemsPerRow) continue;
            col = 0;
            ++row;
        }
        int screenWidthForButton = client.method_22683().method_4486();
        int buttonStartX = screenWidthForButton - config.itemsPerRow * 20 - 10;
        int toggleY = startY + config.rowsPerPage * 20 + 5;
        String toggleText = config.showOnlyCraftable ? "Show All" : "Craftables Only";
        int toggleWidth = client.field_1772.method_1727(toggleText) + 8;
        boolean toggleHovered = mouseX >= buttonStartX && mouseX <= buttonStartX + toggleWidth && mouseY >= toggleY && mouseY <= toggleY + 12;
        context.method_25294(buttonStartX, toggleY, buttonStartX + toggleWidth, toggleY + 12, toggleHovered ? -1 : -10066330);
        context.method_51433(client.field_1772, toggleText, buttonStartX + 4, toggleY + 2, toggleHovered ? 0 : 0xFFFFFF, false);
        context.method_51433(client.field_1772, "Page " + (currentPage + 1) + " / " + totalPages, buttonStartX, toggleY + 15, 0xFFFFFF, false);
        if (hoveredItem != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            class_1799 stack = new class_1799((class_1935)hoveredItem);
            context.method_51434(client.field_1772, List.of(stack.method_7964()), mouseX, mouseY);
            context.method_51448().method_22909();
        }
    }

    public static boolean handleClick(double mouseX, double mouseY) {
        if (searchField != null) {
            int searchX = searchField.method_46426();
            int searchY = searchField.method_46427();
            int searchWidth = searchField.method_25368();
            int searchHeight = searchField.method_25364();
            if (mouseX >= (double)searchX && mouseX <= (double)(searchX + searchWidth) && mouseY >= (double)searchY && mouseY <= (double)(searchY + searchHeight)) {
                searchField.method_25402(mouseX, mouseY, 0);
                searchField.method_25365(true);
                searchFieldFocused = true;
                return true;
            }
            searchField.method_25365(false);
            searchFieldFocused = false;
        }
        RecipeViewerConfig config = RecipeViewerConfig.getInstance();
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int buttonStartX = screenWidth - config.itemsPerRow * 20 - 10;
        int toggleY = 25 + config.rowsPerPage * 20 + 5;
        String toggleText = config.showOnlyCraftable ? "Show All" : "Craftables Only";
        int toggleWidth = class_310.method_1551().field_1772.method_1727(toggleText) + 8;
        if (mouseX >= (double)buttonStartX && mouseX <= (double)(buttonStartX + toggleWidth) && mouseY >= (double)toggleY && mouseY <= (double)(toggleY + 12)) {
            config.toggleShowOnlyCraftable();
            ItemListOverlay.updateFilteredItems();
            return true;
        }
        for (Map.Entry<class_768, class_1792> entry : clickableAreas.entrySet()) {
            class_768 rect = entry.getKey();
            if (!(mouseX >= (double)rect.method_3321()) || !(mouseX <= (double)(rect.method_3321() + rect.method_3319())) || !(mouseY >= (double)rect.method_3322()) || !(mouseY <= (double)(rect.method_3322() + rect.method_3320()))) continue;
            ItemListOverlay.setPreviousScreen(class_310.method_1551().field_1755);
            class_310.method_1551().method_1507((class_437)new RecipeScreen(entry.getValue()));
            return true;
        }
        return false;
    }

    public static boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (searchField != null && searchField.method_25370()) {
            boolean handled = searchField.method_25404(keyCode, scanCode, modifiers);
            if (handled) {
                return true;
            }
            if (keyCode == 259) {
                String currentText = searchField.method_1882();
                if (!currentText.isEmpty()) {
                    searchField.method_1852(currentText.substring(0, currentText.length() - 1));
                    return true;
                }
            } else if (keyCode == 261) {
                return true;
            }
            if (keyCode >= 32 && keyCode <= 126) {
                char character = (char)keyCode;
                if ((modifiers & 1) != 0) {
                    if (character >= 'a' && character <= 'z') {
                        character = Character.toUpperCase(character);
                    } else if (character >= '0' && character <= '9') {
                        String shiftedSymbols = ")!@#$%^&*(";
                        character = shiftedSymbols.charAt(character - 48);
                    }
                } else if (character >= 'A' && character <= 'Z') {
                    character = Character.toLowerCase(character);
                }
                String currentText = searchField.method_1882();
                String newText = currentText + character;
                searchField.method_1852(newText);
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean handleScroll(double amount) {
        if (amount > 0.0 && currentPage > 0) {
            --currentPage;
            return true;
        }
        if (amount < 0.0 && currentPage < totalPages - 1) {
            ++currentPage;
            return true;
        }
        return false;
    }

    public static void preloadCraftableItems() {
        if (isCraftableCacheLoaded) {
            return;
        }
        new Thread(() -> {
            try {
                CRAFTABLE_ITEMS_CACHE.clear();
                CRAFTABLE_ITEM_IDS.clear();
                ItemListOverlay.populateExtensiveCraftableItems();
                for (class_1792 item : class_7923.field_41178) {
                    String itemId;
                    if (item == class_1802.field_8162 || EXCLUDED_ITEMS.contains(item) || !CRAFTABLE_ITEM_IDS.contains(itemId = class_7923.field_41178.method_10221((Object)item).method_12832()) && !ItemListOverlay.fastCheckHasRecipe(itemId)) continue;
                    CRAFTABLE_ITEMS_CACHE.add(new class_1799((class_1935)item));
                }
                isCraftableCacheLoaded = true;
                System.out.println("Craftable items cache loaded: " + CRAFTABLE_ITEMS_CACHE.size() + " items");
                class_310.method_1551().execute(() -> {
                    if (RecipeViewerConfig.getInstance().showOnlyCraftable) {
                        ItemListOverlay.updateFilteredItems();
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error preloading craftable items: " + e.getMessage());
            }
        }).start();
    }

    private static void populateExtensiveCraftableItems() {
        String[] craftableItems;
        for (String itemName : craftableItems = new String[]{"oak_planks", "spruce_planks", "birch_planks", "jungle_planks", "acacia_planks", "dark_oak_planks", "cherry_planks", "mangrove_planks", "bamboo_planks", "crimson_planks", "warped_planks", "stick", "bowl", "crafting_table", "furnace", "chest", "ladder", "torch", "soul_torch", "wooden_pickaxe", "wooden_axe", "wooden_shovel", "wooden_sword", "wooden_hoe", "stone_pickaxe", "stone_axe", "stone_shovel", "stone_sword", "stone_hoe", "iron_pickaxe", "iron_axe", "iron_shovel", "iron_sword", "iron_hoe", "golden_pickaxe", "golden_axe", "golden_shovel", "golden_sword", "golden_hoe", "diamond_pickaxe", "diamond_axe", "diamond_shovel", "diamond_sword", "diamond_hoe", "netherite_pickaxe", "netherite_axe", "netherite_shovel", "netherite_sword", "netherite_hoe", "leather_helmet", "leather_chestplate", "leather_leggings", "leather_boots", "chainmail_helmet", "chainmail_chestplate", "chainmail_leggings", "chainmail_boots", "iron_helmet", "iron_chestplate", "iron_leggings", "iron_boots", "golden_helmet", "golden_chestplate", "golden_leggings", "golden_boots", "diamond_helmet", "diamond_chestplate", "diamond_leggings", "diamond_boots", "netherite_helmet", "netherite_chestplate", "netherite_leggings", "netherite_boots", "bread", "cake", "cookie", "pumpkin_pie", "mushroom_stew", "rabbit_stew", "beetroot_soup", "suspicious_stew", "honey_bottle", "sugar", "golden_apple", "golden_carrot", "cobblestone", "stone", "stone_bricks", "mossy_stone_bricks", "cracked_stone_bricks", "chiseled_stone_bricks", "smooth_stone", "smooth_stone_slab", "cobblestone_slab", "stone_slab", "stone_brick_slab", "mossy_stone_brick_slab", "smooth_sandstone", "cut_sandstone", "chiseled_sandstone", "red_sandstone", "smooth_red_sandstone", "cut_red_sandstone", "chiseled_red_sandstone", "bricks", "nether_bricks", "red_nether_bricks", "chiseled_nether_bricks", "cracked_nether_bricks", "glass", "glass_pane", "white_stained_glass", "orange_stained_glass", "magenta_stained_glass", "light_blue_stained_glass", "yellow_stained_glass", "lime_stained_glass", "pink_stained_glass", "gray_stained_glass", "light_gray_stained_glass", "cyan_stained_glass", "purple_stained_glass", "blue_stained_glass", "brown_stained_glass", "green_stained_glass", "red_stained_glass", "black_stained_glass", "redstone_torch", "redstone_block", "repeater", "comparator", "piston", "sticky_piston", "redstone_lamp", "daylight_detector", "tripwire_hook", "dropper", "dispenser", "hopper", "observer", "target", "lectern", "note_block", "jukebox", "rail", "powered_rail", "detector_rail", "activator_rail", "minecart", "chest_minecart", "furnace_minecart", "hopper_minecart", "tnt_minecart", "oak_boat", "spruce_boat", "birch_boat", "jungle_boat", "acacia_boat", "dark_oak_boat", "cherry_boat", "mangrove_boat", "bamboo_raft", "anvil", "enchanting_table", "bookshelf", "ender_chest", "shulker_box", "barrel", "smoker", "blast_furnace", "grindstone", "stonecutter", "loom", "cartography_table", "fletching_table", "smithing_table", "brewing_stand", "cauldron", "composter", "bee_nest", "beehive", "campfire", "soul_campfire", "lantern", "soul_lantern", "flower_pot", "item_frame", "glow_item_frame", "painting", "armor_stand", "end_rod", "chorus_fruit", "purpur_block", "purpur_pillar", "purpur_slab", "purpur_stairs", "end_stone_bricks", "sea_lantern", "prismarine", "prismarine_bricks", "dark_prismarine", "iron_ingot", "gold_ingot", "copper_ingot", "netherite_ingot", "diamond", "emerald", "coal", "charcoal", "quartz", "amethyst_shard", "leather", "paper", "book", "writable_book", "written_book", "map", "clock", "compass", "recovery_compass", "bundle", "spyglass", "lead", "name_tag", "saddle"}) {
            CRAFTABLE_ITEM_IDS.add(itemName);
        }
    }

    private static boolean fastCheckHasRecipe(String itemName) {
        if (itemName.endsWith("_planks") || itemName.endsWith("_log") || itemName.endsWith("_wood") || itemName.endsWith("_slab") || itemName.endsWith("_stairs") || itemName.endsWith("_fence") || itemName.endsWith("_door") || itemName.endsWith("_trapdoor") || itemName.endsWith("_button") || itemName.endsWith("_pressure_plate") || itemName.endsWith("_sign") || itemName.endsWith("_hanging_sign")) {
            return true;
        }
        if (RECIPE_CACHE.containsKey(itemName)) {
            return RECIPE_CACHE.get(itemName);
        }
        return ItemListOverlay.checkRecipeExists(itemName);
    }

    static {
        lastSearchText = "";
        searchFieldInitialized = false;
        searchFieldFocused = false;
        previousScreen = null;
        lastFilterUpdateTime = 0L;
        clickableAreas = new HashMap<class_768, class_1792>();
        currentPage = 0;
        totalPages = 1;
    }
}

