/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class RecipeViewerConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("lessthanenoughitems.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean showOnlyCraftable = true;
    public boolean useNewUI = true;
    public int itemsPerRow = 15;
    public int rowsPerPage = 20;
    private static RecipeViewerConfig instance;

    public static RecipeViewerConfig getInstance() {
        if (instance == null) {
            instance = RecipeViewerConfig.load();
        }
        return instance;
    }

    private static RecipeViewerConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (RecipeViewerConfig)GSON.fromJson(json, RecipeViewerConfig.class);
            }
            catch (Exception e) {
                System.err.println("Failed to load config, using defaults: " + e.getMessage());
            }
        }
        return new RecipeViewerConfig();
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void toggleShowOnlyCraftable() {
        this.showOnlyCraftable = !this.showOnlyCraftable;
        this.save();
    }

    public void toggleNewUI() {
        this.useNewUI = !this.useNewUI;
        this.save();
    }
}

