/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.loading.FMLPaths;

public class ConfigManager {
    private static final String CONFIG_FILENAME = "hibernateforge.json";

    public static void loadConfig() {
        try {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path configFile = configDir.resolve(CONFIG_FILENAME);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (Files.notExists(configFile, new LinkOption[0])) {
                JsonObject defaults = ConfigManager.createDefaultConfig();
                Files.createDirectories(configDir, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(configFile, StandardOpenOption.CREATE_NEW);){
                    gson.toJson((JsonElement)defaults, (Appendable)writer);
                }
                Constants.LOG.info("Configuration file created: {}", (Object)configFile);
            }
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                JsonObject config = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                ConfigManager.applyConfigValues(config);
                Constants.LOG.info("Configuration successfully loaded");
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Error loading configuration, using default values: ", (Throwable)e);
        }
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("_comment", "Hibernateforge configuration \u2014 Edit as needed");
        config.addProperty("startEnabled", Boolean.valueOf(CommonConfig.startEnabled));
        config.addProperty("ticksToSkip", (Number)CommonConfig.ticksToSkip);
        config.addProperty("permissionLevel", (Number)CommonConfig.permissionLevel);
        config.addProperty("enableMemoryOptimization", Boolean.valueOf(CommonConfig.enableMemoryOptimization));
        config.addProperty("memoryCleanupIntervalSeconds", (Number)CommonConfig.memoryCleanupIntervalSeconds);
        config.addProperty("memoryThresholdPercent", (Number)CommonConfig.memoryThresholdPercent);
        config.addProperty("maxChunksToUnloadPerTick", (Number)CommonConfig.maxChunksToUnloadPerTick);
        config.addProperty("forceGarbageCollection", Boolean.valueOf(CommonConfig.forceGarbageCollection));
        config.addProperty("gcIntervalSeconds", (Number)CommonConfig.gcIntervalSeconds);
        config.addProperty("saveBeforeHibernation", Boolean.valueOf(CommonConfig.saveBeforeHibernation));
        config.addProperty("removeOldDroppedItems", Boolean.valueOf(CommonConfig.removeOldDroppedItems));
        config.addProperty("droppedItemMaxAgeSeconds", (Number)CommonConfig.droppedItemMaxAgeSeconds);
        config.addProperty("removeProjectiles", Boolean.valueOf(CommonConfig.removeProjectiles));
        config.addProperty("removeExperienceOrbs", Boolean.valueOf(CommonConfig.removeExperienceOrbs));
        config.addProperty("compactDataStructures", Boolean.valueOf(CommonConfig.compactDataStructures));
        config.addProperty("logMemoryUsage", Boolean.valueOf(CommonConfig.logMemoryUsage));
        return config;
    }

    private static void applyConfigValues(JsonObject config) {
        CommonConfig.startEnabled = ConfigManager.getBoolean(config, "startEnabled", CommonConfig.startEnabled);
        CommonConfig.ticksToSkip = ConfigManager.getLong(config, "ticksToSkip", CommonConfig.ticksToSkip);
        CommonConfig.permissionLevel = ConfigManager.getInt(config, "permissionLevel", CommonConfig.permissionLevel);
        CommonConfig.enableMemoryOptimization = ConfigManager.getBoolean(config, "enableMemoryOptimization", CommonConfig.enableMemoryOptimization);
        CommonConfig.memoryCleanupIntervalSeconds = ConfigManager.getInt(config, "memoryCleanupIntervalSeconds", CommonConfig.memoryCleanupIntervalSeconds);
        CommonConfig.memoryThresholdPercent = ConfigManager.getDouble(config, "memoryThresholdPercent", CommonConfig.memoryThresholdPercent);
        CommonConfig.maxChunksToUnloadPerTick = ConfigManager.getInt(config, "maxChunksToUnloadPerTick", CommonConfig.maxChunksToUnloadPerTick);
        CommonConfig.forceGarbageCollection = ConfigManager.getBoolean(config, "forceGarbageCollection", CommonConfig.forceGarbageCollection);
        CommonConfig.gcIntervalSeconds = ConfigManager.getInt(config, "gcIntervalSeconds", CommonConfig.gcIntervalSeconds);
        CommonConfig.saveBeforeHibernation = ConfigManager.getBoolean(config, "saveBeforeHibernation", CommonConfig.saveBeforeHibernation);
        CommonConfig.removeOldDroppedItems = ConfigManager.getBoolean(config, "removeOldDroppedItems", CommonConfig.removeOldDroppedItems);
        CommonConfig.droppedItemMaxAgeSeconds = ConfigManager.getInt(config, "droppedItemMaxAgeSeconds", CommonConfig.droppedItemMaxAgeSeconds);
        CommonConfig.removeProjectiles = ConfigManager.getBoolean(config, "removeProjectiles", CommonConfig.removeProjectiles);
        CommonConfig.removeExperienceOrbs = ConfigManager.getBoolean(config, "removeExperienceOrbs", CommonConfig.removeExperienceOrbs);
        CommonConfig.compactDataStructures = ConfigManager.getBoolean(config, "compactDataStructures", CommonConfig.compactDataStructures);
        CommonConfig.logMemoryUsage = ConfigManager.getBoolean(config, "logMemoryUsage", CommonConfig.logMemoryUsage);
    }

    private static boolean getBoolean(JsonObject config, String key, boolean defaultValue) {
        try {
            return config.has(key) ? config.get(key).getAsBoolean() : defaultValue;
        }
        catch (Exception e) {
            Constants.LOG.warn("Error reading configuration '{}', using default value: {}", (Object)key, (Object)defaultValue);
            return defaultValue;
        }
    }

    private static int getInt(JsonObject config, String key, int defaultValue) {
        try {
            return config.has(key) ? config.get(key).getAsInt() : defaultValue;
        }
        catch (Exception e) {
            Constants.LOG.warn("Error reading configuration '{}', using default value: {}", (Object)key, (Object)defaultValue);
            return defaultValue;
        }
    }

    private static long getLong(JsonObject config, String key, long defaultValue) {
        try {
            return config.has(key) ? config.get(key).getAsLong() : defaultValue;
        }
        catch (Exception e) {
            Constants.LOG.warn("Error reading configuration '{}', using default value: {}", (Object)key, (Object)defaultValue);
            return defaultValue;
        }
    }

    private static double getDouble(JsonObject config, String key, double defaultValue) {
        try {
            return config.has(key) ? config.get(key).getAsDouble() : defaultValue;
        }
        catch (Exception e) {
            Constants.LOG.warn("Error reading configuration '{}', using default value: {}", (Object)key, (Object)defaultValue);
            return defaultValue;
        }
    }

    public static void saveConfig() {
        try {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path configFile = configDir.resolve(CONFIG_FILENAME);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject config = ConfigManager.createDefaultConfig();
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
            Constants.LOG.info("Configuration saved to: {}", (Object)configFile);
        }
        catch (IOException e) {
            Constants.LOG.error("Error saving configuration: ", (Throwable)e);
        }
    }
}

