/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.Constants;
import com.nyakotech.hibernateforge.Hibernation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

public class GameRuleHandler {
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        if (CommonConfig.startEnabled && server.getPlayerList().getPlayers().isEmpty()) {
            Constants.LOG.info("Server started with no players \u2014 enabling hibernation");
            Hibernation.setHibernating(true);
            GameRuleHandler.setHibernationGameRules(server, true);
        } else {
            Constants.LOG.info("Server started with hibernation disabled");
            Hibernation.setHibernating(false);
            GameRuleHandler.setHibernationGameRules(server, false);
        }
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.getServer();
        if (Hibernation.isHibernating()) {
            Constants.LOG.info("Player {} connected \u2014 disabling hibernation", (Object)player.getName().getString());
            Hibernation.setHibernating(false);
            GameRuleHandler.setHibernationGameRules(server, false);
        }
    }

    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.getServer();
        server.execute(() -> {
            if (server.getPlayerList().getPlayers().isEmpty()) {
                Constants.LOG.info("Last player {} disconnected \u2014 enabling hibernation", (Object)player.getName().getString());
                Hibernation.setHibernating(true);
                GameRuleHandler.setHibernationGameRules(server, true);
            } else {
                Constants.LOG.debug("Player {} disconnected, but there are still {} players online", (Object)player.getName().getString(), (Object)server.getPlayerList().getPlayers().size());
            }
        });
    }

    public static void setHibernationGameRules(MinecraftServer server, boolean hibernating) {
        GameRules rules = server.getGameRules();
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DAYLIGHT)).set(!hibernating, server);
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_WEATHER_CYCLE)).set(!hibernating, server);
        ((GameRules.IntegerValue)rules.getRule(GameRules.RULE_RANDOMTICKING)).set(hibernating ? 0 : 3, server);
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOMOBSPAWNING)).set(!hibernating, server);
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOFIRETICK)).set(!hibernating, server);
    }
}

