/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.ChunkUnloadHandler;
import com.nyakotech.hibernateforge.CommonClass;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.ConfigManager;
import com.nyakotech.hibernateforge.Constants;
import com.nyakotech.hibernateforge.GameRuleHandler;
import com.nyakotech.hibernateforge.Hibernation;
import com.nyakotech.hibernateforge.HibernationCommand;
import com.nyakotech.hibernateforge.MemoryManager;
import com.nyakotech.hibernateforge.TickEventHandler;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod(value="hibernateforge")
public class HibernateforgeNeoforge {
    private static boolean hibernating = false;

    public HibernateforgeNeoforge(IEventBus modBus) {
        Constants.LOG.info("Loading NeoForge module from Hibernateforge");
        ConfigManager.loadConfig();
        CommonClass.init();
        hibernating = CommonConfig.startEnabled;
        Hibernation.setHibernating(hibernating);
        IEventBus gameEventBus = NeoForge.EVENT_BUS;
        gameEventBus.addListener(this::onServerStarted);
        gameEventBus.addListener(this::onServerStopping);
        gameEventBus.addListener(GameRuleHandler::onServerStarted);
        gameEventBus.addListener(HibernationCommand::register);
        gameEventBus.addListener(GameRuleHandler::onPlayerLogin);
        gameEventBus.addListener(GameRuleHandler::onPlayerLogout);
        gameEventBus.addListener(TickEventHandler::onServerTick);
        gameEventBus.addListener(ChunkUnloadHandler::onLevelTick);
        Constants.LOG.info("Hibernateforge NeoForge successfully initialized");
    }

    private void onServerStarted(ServerStartedEvent event) {
        Constants.LOG.info("Server started \u2014 Hibernateforge active");
        if (CommonConfig.startEnabled && event.getServer().getPlayerCount() == 0) {
            HibernateforgeNeoforge.setHibernationState(event.getServer(), true);
        }
    }

    private void onServerStopping(ServerStoppingEvent event) {
        Constants.LOG.info("Server stopping \u2014 disabling hibernation");
        if (CommonConfig.enableMemoryOptimization) {
            MemoryManager.stopMemoryOptimization();
            MemoryManager.shutdown();
        }
        hibernating = false;
        Hibernation.setHibernating(false);
    }

    public static boolean isHibernating() {
        return hibernating;
    }

    public static void setHibernationState(MinecraftServer server, boolean state) {
        boolean wasHibernating = hibernating;
        hibernating = state;
        Hibernation.setHibernating(state);
        GameRuleHandler.setHibernationGameRules(server, state);
        if (CommonConfig.enableMemoryOptimization) {
            if (state && !wasHibernating) {
                Constants.LOG.info("Entering hibernation mode \u2014 starting optimizations");
                if (CommonConfig.saveBeforeHibernation) {
                    MemoryManager.saveImportantData(server);
                }
                MemoryManager.startMemoryOptimization(server);
            } else if (!state && wasHibernating) {
                Constants.LOG.info("Exiting hibernation mode \u2014 stopping optimizations");
                MemoryManager.stopMemoryOptimization();
            }
        }
        Constants.LOG.info("Hibernation state changed: {} -> {}", (Object)(wasHibernating ? "HIBERNATING" : "ACTIVE"), (Object)(state ? "HIBERNATING" : "ACTIVE"));
    }

    public static void forceGarbageCollection() {
        if (CommonConfig.enableMemoryOptimization && CommonConfig.forceGarbageCollection) {
            long beforeGC = HibernateforgeNeoforge.getUsedMemoryMB();
            System.gc();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            long afterGC = HibernateforgeNeoforge.getUsedMemoryMB();
            long memoryFreed = beforeGC - afterGC;
            Constants.LOG.info("Manual GC executed: {}MB freed (Before: {}MB, After: {}MB))", new Object[]{memoryFreed, beforeGC, afterGC});
        }
    }

    public static String getMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 0x100000L;
        long freeMemory = runtime.freeMemory() / 0x100000L;
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory() / 0x100000L;
        long availableMemory = maxMemory - usedMemory;
        double usagePercent = (double)usedMemory / (double)maxMemory * 100.0;
        long totalHeapMB = runtime.totalMemory() / 0x100000L;
        return String.format("Memory: %dMB used / %dMB max (%.1f%%) \u2014 Available: %dMB [Current heap: %dMB]", usedMemory, maxMemory, usagePercent, availableMemory, totalHeapMB);
    }

    private static long getUsedMemoryMB() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
    }

    public static boolean isMemoryOptimizationEnabled() {
        return CommonConfig.enableMemoryOptimization;
    }

    public static void reloadConfig() {
        Constants.LOG.info("Reloading configurations...");
        ConfigManager.loadConfig();
        Constants.LOG.info("Configurations reloaded successfully");
    }

    public static void saveConfig() {
        ConfigManager.saveConfig();
    }
}

