/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.GameRuleHandler;
import com.nyakotech.hibernateforge.Hibernation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class HibernationCommand {
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hibernate").requires(src -> src.hasPermission(CommonConfig.permissionLevel))).executes(HibernationCommand::execute));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        boolean newState;
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        boolean currentState = Hibernation.isHibernating();
        boolean bl = newState = !currentState;
        if (newState && !server.getPlayerList().getPlayers().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cHibernation not possible with players online! (" + server.getPlayerList().getPlayers().size() + " connected players)")));
            return 0;
        }
        if (!newState && server.getPlayerList().getPlayers().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7eAttention: Disabling hibernation with no players online. Hibernation will be automatically reactivated."), true);
        }
        Hibernation.setHibernating(newState);
        GameRuleHandler.setHibernationGameRules(server, newState);
        String status = newState ? "\u00a7aactivated" : "\u00a7cdeactivated";
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7fHibernation " + status + "\u00a7f!")), true);
        return 1;
    }
}

