/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.HibernateforgeNeoforge;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="hibernateforge")
public class MemoryCommand {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hibernate").requires(src -> src.hasPermission(CommonConfig.permissionLevel))).executes(MemoryCommand::toggleHibernation)).then(Commands.literal((String)"status").executes(MemoryCommand::showStatus))).then(Commands.literal((String)"memory").executes(MemoryCommand::showMemoryInfo))).then(Commands.literal((String)"gc").executes(MemoryCommand::forceGarbageCollection)));
    }

    private static int toggleHibernation(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        boolean newState = !HibernateforgeNeoforge.isHibernating();
        HibernateforgeNeoforge.setHibernationState(server, newState);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Hibernation " + (newState ? "activated" : "deactivated"))), true);
        return 1;
    }

    private static int showStatus(CommandContext<CommandSourceStack> ctx) {
        boolean hibernating = HibernateforgeNeoforge.isHibernating();
        int playerCount = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerCount();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Hibernation Status:\n- State: " + (hibernating ? "HIBERNATING" : "ACTIVE") + "\n- Online players: " + playerCount + "\n- Memory Optimization: " + (HibernateforgeNeoforge.isMemoryOptimizationEnabled() ? "ACTIVE" : "INACTIVE"))), false);
        return 1;
    }

    private static int showMemoryInfo(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Memory Information:\n" + HibernateforgeNeoforge.getMemoryInfo())), false);
        return 1;
    }

    private static int forceGarbageCollection(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Performing memory cleanup..."), false);
        HibernateforgeNeoforge.forceGarbageCollection();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Memory cleanup executed!\n" + HibernateforgeNeoforge.getMemoryInfo())), false);
        return 1;
    }
}

