/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.Hibernation;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class TickEventHandler {
    private static long tickCounter = 0L;
    private static boolean wasHibernating = false;

    public static void onServerTick(ServerTickEvent.Pre event) {
        boolean isHibernating = Hibernation.isHibernating();
        if (isHibernating != wasHibernating) {
            tickCounter = 0L;
            wasHibernating = isHibernating;
        }
        if (isHibernating) {
            if (++tickCounter >= CommonConfig.ticksToSkip) {
                tickCounter = 0L;
                try {
                    Thread.sleep((long)CommonConfig.sleepTimeMs * 2L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (tickCounter % 5L == 0L) {
                Thread.yield();
            }
        }
    }
}

