/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nyakotech.hibernateforge.ChunkUnloadHandler;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.GameRuleHandler;
import com.nyakotech.hibernateforge.HibernationCommand;
import com.nyakotech.hibernateforge.TickEventHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public class HibernateforgeFabric
implements ModInitializer {
    private static boolean hibernating;

    public void onInitialize() {
        this.loadConfig();
        hibernating = CommonConfig.startEnabled;
        HibernationCommand.register();
        GameRuleHandler.register();
        TickEventHandler.register();
        ChunkUnloadHandler.register();
    }

    public static boolean isHibernating() {
        return hibernating;
    }

    public static void setHibernationState(MinecraftServer server, boolean state) {
        hibernating = state;
        GameRuleHandler.setHibernationGameRules(server, state);
    }

    private void loadConfig() {
        try {
            Path cfgDir = FabricLoader.getInstance().getConfigDir();
            Path cfgFile = cfgDir.resolve("hibernateforge.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (Files.notExists(cfgFile, new LinkOption[0])) {
                JsonObject defaults = new JsonObject();
                defaults.addProperty("startEnabled", Boolean.valueOf(CommonConfig.startEnabled));
                defaults.addProperty("ticksToSkip", (Number)CommonConfig.ticksToSkip);
                defaults.addProperty("permissionLevel", (Number)CommonConfig.permissionLevel);
                Files.createDirectories(cfgDir, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(cfgFile, StandardOpenOption.CREATE_NEW);){
                    gson.toJson((JsonElement)defaults, (Appendable)writer);
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(cfgFile);){
                JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                CommonConfig.startEnabled = obj.has("startEnabled") ? obj.get("startEnabled").getAsBoolean() : CommonConfig.startEnabled;
                CommonConfig.ticksToSkip = obj.has("ticksToSkip") ? obj.get("ticksToSkip").getAsLong() : CommonConfig.ticksToSkip;
                CommonConfig.permissionLevel = obj.has("permissionLevel") ? obj.get("permissionLevel").getAsInt() : CommonConfig.permissionLevel;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load hibernateforge config, using defaults:");
            e.printStackTrace();
        }
    }
}

