/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.HibernateforgeFabric;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;

public class TickEventHandler {
    private static int onlinePlayers = 0;

    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, client, server) -> {
            ++onlinePlayers;
            if (HibernateforgeFabric.isHibernating()) {
                HibernateforgeFabric.setHibernationState(server, false);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (--onlinePlayers <= 0 && HibernateforgeFabric.isHibernating()) {
                HibernateforgeFabric.setHibernationState(server, true);
            }
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (HibernateforgeFabric.isHibernating()) {
                try {
                    Thread.sleep(CommonConfig.ticksToSkip);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }
}

