/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.Constants;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1928;
import net.minecraft.server.MinecraftServer;

public class GameRuleHandler {
    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (CommonConfig.startEnabled && server.method_3760().method_14571().isEmpty()) {
                Constants.LOG.info("Server started with no players \u2013 applying hibernation game rules.");
                GameRuleHandler.setHibernationGameRules(server, true);
            } else {
                Constants.LOG.info("Server started \u2013 applying normal game rules.");
                GameRuleHandler.setHibernationGameRules(server, false);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            Constants.LOG.debug("Player {} connected \u2013 applying normal game rules.", (Object)handler.method_32311().method_5477().getString());
            GameRuleHandler.setHibernationGameRules(server, false);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            String playerName = handler.method_32311().method_5477().getString();
            server.execute(() -> {
                if (server.method_3760().method_14571().isEmpty()) {
                    Constants.LOG.info("Last player {} disconnected \u2013 applying hibernation game rules.", (Object)playerName);
                    GameRuleHandler.setHibernationGameRules(server, true);
                } else {
                    Constants.LOG.debug("Player {} disconnected, but there are still {} players online \u2013 keeping normal game rules.", (Object)playerName, (Object)server.method_3760().method_14571().size());
                }
            });
        });
    }

    public static void setHibernationGameRules(MinecraftServer server, boolean hibernating) {
        class_1928 rules = server.method_3767();
        ((class_1928.class_4310)rules.method_20746(class_1928.field_19396)).method_20758(!hibernating, server);
        ((class_1928.class_4310)rules.method_20746(class_1928.field_19406)).method_20758(!hibernating, server);
        ((class_1928.class_4312)rules.method_20746(class_1928.field_19399)).method_35236(hibernating ? 0 : 3, server);
        ((class_1928.class_4310)rules.method_20746(class_1928.field_19390)).method_20758(!hibernating, server);
        ((class_1928.class_4310)rules.method_20746(class_1928.field_19387)).method_20758(!hibernating, server);
        if (hibernating) {
            Constants.LOG.debug("Game rules set for hibernation: daylight=false, weather=false, randomTick=0, mobSpawn=false, fire=false");
        } else {
            Constants.LOG.debug("Game rules set to normal mode: daylight=true, weather=true, randomTick=3, mobSpawn=true, fire=true");
        }
    }
}

