/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nyakotech.hibernateforge.ChunkUnloadHandler;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.GameRuleHandler;
import com.nyakotech.hibernateforge.HibernationCommand;
import com.nyakotech.hibernateforge.MemoryCommand;
import com.nyakotech.hibernateforge.MemoryManager;
import com.nyakotech.hibernateforge.TickEventHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public class HibernateforgeFabric
implements ModInitializer {
    private static boolean hibernating;

    public void onInitialize() {
        this.loadConfig();
        hibernating = CommonConfig.startEnabled;
        HibernationCommand.register();
        MemoryCommand.register();
        GameRuleHandler.register();
        TickEventHandler.register();
        ChunkUnloadHandler.register();
        Runtime.getRuntime().addShutdownHook(new Thread(MemoryManager::shutdown));
    }

    public static boolean isHibernating() {
        return hibernating;
    }

    public static void setHibernationState(MinecraftServer server, boolean state) {
        boolean wasHibernating = hibernating;
        hibernating = state;
        GameRuleHandler.setHibernationGameRules(server, state);
        if (state && !wasHibernating) {
            if (CommonConfig.enableMemoryOptimization) {
                if (CommonConfig.saveBeforeHibernation) {
                    MemoryManager.saveImportantData(server);
                }
                MemoryManager.startMemoryOptimization(server);
            }
        } else if (!state && wasHibernating && CommonConfig.enableMemoryOptimization) {
            MemoryManager.stopMemoryOptimization();
        }
    }

    private void loadConfig() {
        try {
            Path cfgDir = FabricLoader.getInstance().getConfigDir();
            Path cfgFile = cfgDir.resolve("hibernateforge.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (Files.notExists(cfgFile, new LinkOption[0])) {
                JsonObject defaults = new JsonObject();
                defaults.addProperty("startEnabled", Boolean.valueOf(CommonConfig.startEnabled));
                defaults.addProperty("ticksToSkip", (Number)CommonConfig.ticksToSkip);
                defaults.addProperty("permissionLevel", (Number)CommonConfig.permissionLevel);
                defaults.addProperty("sleepTimeMs", (Number)CommonConfig.sleepTimeMs);
                defaults.addProperty("aggressiveCpuSaving", Boolean.valueOf(CommonConfig.aggressiveCpuSaving));
                defaults.addProperty("minSleepInterval", (Number)CommonConfig.minSleepInterval);
                defaults.addProperty("highLoadSleepMultiplier", (Number)CommonConfig.highLoadSleepMultiplier);
                defaults.addProperty("yieldInterval", (Number)CommonConfig.yieldInterval);
                Files.createDirectories(cfgDir, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(cfgFile, StandardOpenOption.CREATE_NEW);){
                    gson.toJson((JsonElement)defaults, (Appendable)writer);
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(cfgFile);){
                JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                CommonConfig.startEnabled = obj.has("startEnabled") ? obj.get("startEnabled").getAsBoolean() : CommonConfig.startEnabled;
                CommonConfig.ticksToSkip = obj.has("ticksToSkip") ? obj.get("ticksToSkip").getAsLong() : CommonConfig.ticksToSkip;
                CommonConfig.permissionLevel = obj.has("permissionLevel") ? obj.get("permissionLevel").getAsInt() : CommonConfig.permissionLevel;
                CommonConfig.sleepTimeMs = obj.has("sleepTimeMs") ? obj.get("sleepTimeMs").getAsInt() : CommonConfig.sleepTimeMs;
                CommonConfig.aggressiveCpuSaving = obj.has("aggressiveCpuSaving") ? obj.get("aggressiveCpuSaving").getAsBoolean() : CommonConfig.aggressiveCpuSaving;
                CommonConfig.minSleepInterval = obj.has("minSleepInterval") ? obj.get("minSleepInterval").getAsLong() : CommonConfig.minSleepInterval;
                CommonConfig.highLoadSleepMultiplier = obj.has("highLoadSleepMultiplier") ? obj.get("highLoadSleepMultiplier").getAsDouble() : CommonConfig.highLoadSleepMultiplier;
                CommonConfig.yieldInterval = obj.has("yieldInterval") ? obj.get("yieldInterval").getAsInt() : CommonConfig.yieldInterval;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load hibernateforge config, using defaults:");
            e.printStackTrace();
        }
    }

    private JsonObject createDefaultConfig() {
        JsonObject defaults = new JsonObject();
        defaults.addProperty("startEnabled", Boolean.valueOf(CommonConfig.startEnabled));
        defaults.addProperty("ticksToSkip", (Number)CommonConfig.ticksToSkip);
        defaults.addProperty("permissionLevel", (Number)CommonConfig.permissionLevel);
        defaults.addProperty("enableMemoryOptimization", Boolean.valueOf(CommonConfig.enableMemoryOptimization));
        defaults.addProperty("memoryCleanupIntervalSeconds", (Number)CommonConfig.memoryCleanupIntervalSeconds);
        defaults.addProperty("memoryThresholdPercent", (Number)CommonConfig.memoryThresholdPercent);
        defaults.addProperty("maxChunksToUnloadPerTick", (Number)CommonConfig.maxChunksToUnloadPerTick);
        defaults.addProperty("forceGarbageCollection", Boolean.valueOf(CommonConfig.forceGarbageCollection));
        defaults.addProperty("gcIntervalSeconds", (Number)CommonConfig.gcIntervalSeconds);
        defaults.addProperty("saveBeforeHibernation", Boolean.valueOf(CommonConfig.saveBeforeHibernation));
        defaults.addProperty("removeOldDroppedItems", Boolean.valueOf(CommonConfig.removeOldDroppedItems));
        defaults.addProperty("droppedItemMaxAgeSeconds", (Number)CommonConfig.droppedItemMaxAgeSeconds);
        defaults.addProperty("removeProjectiles", Boolean.valueOf(CommonConfig.removeProjectiles));
        defaults.addProperty("removeExperienceOrbs", Boolean.valueOf(CommonConfig.removeExperienceOrbs));
        defaults.addProperty("compactDataStructures", Boolean.valueOf(CommonConfig.compactDataStructures));
        defaults.addProperty("logMemoryUsage", Boolean.valueOf(CommonConfig.logMemoryUsage));
        return defaults;
    }

    private void loadConfigValues(JsonObject obj) {
        CommonConfig.startEnabled = this.getBoolean(obj, "startEnabled", CommonConfig.startEnabled);
        CommonConfig.ticksToSkip = this.getLong(obj, "ticksToSkip", CommonConfig.ticksToSkip);
        CommonConfig.permissionLevel = this.getInt(obj, "permissionLevel", CommonConfig.permissionLevel);
        CommonConfig.enableMemoryOptimization = this.getBoolean(obj, "enableMemoryOptimization", CommonConfig.enableMemoryOptimization);
        CommonConfig.memoryCleanupIntervalSeconds = this.getInt(obj, "memoryCleanupIntervalSeconds", CommonConfig.memoryCleanupIntervalSeconds);
        CommonConfig.memoryThresholdPercent = this.getDouble(obj, "memoryThresholdPercent", CommonConfig.memoryThresholdPercent);
        CommonConfig.maxChunksToUnloadPerTick = this.getInt(obj, "maxChunksToUnloadPerTick", CommonConfig.maxChunksToUnloadPerTick);
        CommonConfig.forceGarbageCollection = this.getBoolean(obj, "forceGarbageCollection", CommonConfig.forceGarbageCollection);
        CommonConfig.gcIntervalSeconds = this.getInt(obj, "gcIntervalSeconds", CommonConfig.gcIntervalSeconds);
        CommonConfig.saveBeforeHibernation = this.getBoolean(obj, "saveBeforeHibernation", CommonConfig.saveBeforeHibernation);
        CommonConfig.removeOldDroppedItems = this.getBoolean(obj, "removeOldDroppedItems", CommonConfig.removeOldDroppedItems);
        CommonConfig.droppedItemMaxAgeSeconds = this.getInt(obj, "droppedItemMaxAgeSeconds", CommonConfig.droppedItemMaxAgeSeconds);
        CommonConfig.removeProjectiles = this.getBoolean(obj, "removeProjectiles", CommonConfig.removeProjectiles);
        CommonConfig.removeExperienceOrbs = this.getBoolean(obj, "removeExperienceOrbs", CommonConfig.removeExperienceOrbs);
        CommonConfig.compactDataStructures = this.getBoolean(obj, "compactDataStructures", CommonConfig.compactDataStructures);
        CommonConfig.logMemoryUsage = this.getBoolean(obj, "logMemoryUsage", CommonConfig.logMemoryUsage);
    }

    private boolean getBoolean(JsonObject obj, String key, boolean defaultValue) {
        return obj.has(key) ? obj.get(key).getAsBoolean() : defaultValue;
    }

    private int getInt(JsonObject obj, String key, int defaultValue) {
        return obj.has(key) ? obj.get(key).getAsInt() : defaultValue;
    }

    private long getLong(JsonObject obj, String key, long defaultValue) {
        return obj.has(key) ? obj.get(key).getAsLong() : defaultValue;
    }

    private double getDouble(JsonObject obj, String key, double defaultValue) {
        return obj.has(key) ? obj.get(key).getAsDouble() : defaultValue;
    }
}

