/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.HibernateforgeFabric;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class MemoryCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hibernate").requires(src -> src.method_9259(CommonConfig.permissionLevel))).executes(MemoryCommand::toggleHibernation)).then(class_2170.method_9247((String)"status").executes(MemoryCommand::showStatus))).then(class_2170.method_9247((String)"memory").executes(MemoryCommand::showMemoryInfo))).then(class_2170.method_9247((String)"gc").executes(MemoryCommand::forceGarbageCollection))));
    }

    private static int toggleHibernation(CommandContext<class_2168> ctx) {
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        boolean newState = !HibernateforgeFabric.isHibernating();
        HibernateforgeFabric.setHibernationState(server, newState);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Hibernation " + (newState ? "activated" : "deactivated"))), true);
        return 1;
    }

    private static int showStatus(CommandContext<class_2168> ctx) {
        boolean hibernating = HibernateforgeFabric.isHibernating();
        int playerCount = ((class_2168)ctx.getSource()).method_9211().method_3788();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Hibernation Status:\n- State: " + (hibernating ? "HIBERNATING" : "ACTIVE") + "\n- Players online: " + playerCount + "\n- Memory optimization: " + (CommonConfig.enableMemoryOptimization ? "ACTIVE" : "INACTIVE"))), false);
        return 1;
    }

    private static int showMemoryInfo(CommandContext<class_2168> ctx) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 0x100000L;
        long freeMemory = runtime.freeMemory() / 0x100000L;
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory() / 0x100000L;
        double usagePercent = (double)usedMemory / (double)maxMemory * 100.0;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Memory Information:\n- Memory used: " + usedMemory + "MB\n- Total allocated memory: " + totalMemory + "MB\n- Maximum memory: " + maxMemory + "MB\n- Usage: " + String.format("%.1f%%", usagePercent) + "\n- Free memory: " + freeMemory + "MB")), false);
        return 1;
    }

    private static int forceGarbageCollection(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Performing memory cleanup..."), false);
        long beforeGC = MemoryCommand.getUsedMemoryMB();
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long afterGC = MemoryCommand.getUsedMemoryMB();
        long memoryFreed = beforeGC - afterGC;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Memory cleanup completed!\n- Memory before: " + beforeGC + "MB\n- Memory after: " + afterGC + "MB\n- Memory freed: " + memoryFreed + "MB")), false);
        return 1;
    }

    private static long getUsedMemoryMB() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
    }
}

