/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.Constants;
import com.nyakotech.hibernateforge.HibernateforgeFabric;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;

public class TickEventHandler {
    private static int onlinePlayers = 0;
    private static long tickCounter = 0L;
    private static boolean wasHibernating = false;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (CommonConfig.startEnabled && server.method_3760().method_14571().isEmpty()) {
                Constants.LOG.info("Server started with no players \u2013 activating hibernation.");
                HibernateforgeFabric.setHibernationState(server, true);
            } else {
                Constants.LOG.info("Server started with hibernation disabled.");
                HibernateforgeFabric.setHibernationState(server, false);
                onlinePlayers = server.method_3760().method_14571().size();
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, client, server) -> {
            ++onlinePlayers;
            if (HibernateforgeFabric.isHibernating()) {
                Constants.LOG.info("Player {} connected \u2013 disabling hibernation.", (Object)handler.method_32311().method_5477().getString());
                HibernateforgeFabric.setHibernationState(server, false);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            --onlinePlayers;
            String playerName = handler.method_32311().method_5477().getString();
            server.execute(() -> {
                int actualPlayerCount = server.method_3760().method_14571().size();
                if (actualPlayerCount == 0 && !HibernateforgeFabric.isHibernating()) {
                    Constants.LOG.info("Last player {} disconnected \u2013 activating hibernation.", (Object)playerName);
                    HibernateforgeFabric.setHibernationState(server, true);
                } else if (actualPlayerCount > 0) {
                    Constants.LOG.debug("Player {} disconnected, but there are still {} players online.", (Object)playerName, (Object)actualPlayerCount);
                }
                onlinePlayers = actualPlayerCount;
            });
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            boolean isHibernating = HibernateforgeFabric.isHibernating();
            if (isHibernating && !server.method_3760().method_14571().isEmpty()) {
                Constants.LOG.warn("Hibernation was active with players online \u2013 disabling!");
                HibernateforgeFabric.setHibernationState(server, false);
                onlinePlayers = server.method_3760().method_14571().size();
                return;
            }
            if (isHibernating != wasHibernating) {
                tickCounter = 0L;
                wasHibernating = isHibernating;
            }
            if (isHibernating) {
                if (++tickCounter >= CommonConfig.ticksToSkip) {
                    tickCounter = 0L;
                    try {
                        Thread.sleep(CommonConfig.sleepTimeMs * 2);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (tickCounter % (long)CommonConfig.yieldInterval == 0L) {
                    Thread.yield();
                }
            }
        });
    }
}

