/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.nyakotech.hibernateforge.Hibernation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class GameRuleHandler {
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.getServer();
        Hibernation.setHibernating(false);
        GameRuleHandler.setHibernationGameRules(server, false);
    }

    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.getServer();
        if (server.getPlayerList().getPlayers().isEmpty()) {
            Hibernation.setHibernating(true);
            GameRuleHandler.setHibernationGameRules(server, true);
        }
    }

    public static void setHibernationGameRules(MinecraftServer server, boolean hibernating) {
        GameRules rules = server.getGameRules();
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DAYLIGHT)).set(!hibernating, server);
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_WEATHER_CYCLE)).set(!hibernating, server);
        ((GameRules.IntegerValue)rules.getRule(GameRules.RULE_RANDOMTICKING)).set(hibernating ? 0 : 3, server);
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOMOBSPAWNING)).set(!hibernating, server);
        ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOFIRETICK)).set(!hibernating, server);
    }
}

