/*
 * Decompiled with CFR 0.152.
 */
package com.nyakotech.hibernateforge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nyakotech.hibernateforge.CommonConfig;
import com.nyakotech.hibernateforge.GameRuleHandler;
import com.nyakotech.hibernateforge.Hibernation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class HibernationCommand {
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hibernate").requires(src -> src.hasPermission(CommonConfig.permissionLevel))).executes(HibernationCommand::execute));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        boolean newState = !Hibernation.isHibernating();
        Hibernation.setHibernating(newState);
        GameRuleHandler.setHibernationGameRules(server, newState);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Hibernation set to " + newState)), true);
        return 1;
    }
}

