/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.client;

import com.mc3699.codmod.registry.CodMobEffects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="codmod", value={Dist.CLIENT})
public class ClientGUIEvents {
    private static final ResourceLocation CORRUPTED_HEART = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/gui/corrupt_full.png");
    private static final ResourceLocation VANILLA_HEART = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/hud/heart/full.png");
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onRenderGUI(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player;
        if (event.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH) && (player = Minecraft.getInstance().player) != null && player.hasEffect(CodMobEffects.HEART_CORRUPTION)) {
            event.setCanceled(true);
            ClientGUIEvents.renderCustomHearts(event.getGuiGraphics(), (Player)player);
        }
    }

    private static void renderCustomHearts(GuiGraphics guiGraphics, Player player) {
        int randY;
        int randX;
        int i;
        int maxHealth = (int)player.getMaxHealth();
        int health = (int)player.getHealth();
        int corruptedHearts = (20 - maxHealth) / 2;
        int x = guiGraphics.guiWidth() / 2 - 91;
        int y = guiGraphics.guiHeight() - 39;
        for (i = 0; i < corruptedHearts; ++i) {
            randX = random.nextInt(-5, 5);
            randY = random.nextInt(-5, 5);
            guiGraphics.blit(CORRUPTED_HEART, x + i * 8 + randX, y + randY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        for (i = corruptedHearts; i < health / 2; ++i) {
            randX = random.nextInt(-5, 5);
            randY = random.nextInt(-5, 5);
            guiGraphics.blitSprite(VANILLA_HEART, x + i * 8 + randX, y + randY, 9, 9);
        }
    }
}

