/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.upgrades;

import com.mc3699.codmod.Codmod;
import com.mc3699.codmod.points.PointsManager;
import com.mc3699.codmod.upgrades.Upgrade;
import com.mc3699.codmod.upgrades.Upgrades;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;

public class UpgradeManager {
    private final Map<String, Integer> upgrades = new HashMap<String, Integer>();

    public int getLevel(Upgrade upgrade) {
        return this.upgrades.computeIfAbsent(upgrade.id(), k -> upgrade.defaultLevel());
    }

    public boolean canAffordUpgrade(Upgrade upgrade, PointsManager points) {
        return upgrade.getCost(this.getLevel(upgrade) + 1) <= points.getPoints();
    }

    public boolean upgrade(Upgrade upgrade, PointsManager points) {
        int target = this.getLevel(upgrade) + 1;
        if (upgrade.getCost(target) > points.getPoints()) {
            return false;
        }
        if (target > upgrade.maxLevel()) {
            return false;
        }
        points.addPoints(-upgrade.getCost(target));
        this.upgrades.put(upgrade.id(), target);
        return true;
    }

    public boolean downgrade(Upgrade upgrade, PointsManager points) {
        if (this.getLevel(upgrade) - 1 < 0) {
            return false;
        }
        points.addPoints(upgrade.getCost(this.getLevel(upgrade)));
        this.upgrades.put(upgrade.id(), this.getLevel(upgrade) - 1);
        return true;
    }

    public void setLevel(Upgrade upgrade, int level) {
        this.upgrades.put(upgrade.id(), level);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.upgrades.entrySet()) {
            tag.putInt(entry.getKey(), entry.getValue().intValue());
        }
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        this.upgrades.clear();
        for (String key : tag.getAllKeys()) {
            if (!Upgrades.UPGRADES.containsKey(key)) {
                Codmod.LOGGER.warn("Unknown upgrade ID: {}", (Object)key);
                continue;
            }
            if (tag.getTagType(key) != 3) {
                Codmod.LOGGER.warn("Invalid tag type for upgrade data {}: {}", (Object)key, (Object)tag.getTagType(key));
                continue;
            }
            this.upgrades.put(key, tag.getInt(key));
        }
    }
}

