/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.codNuke;

import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.registry.CodBlockEntities;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CodNukeBlockEntity
extends BlockEntity {
    private int remaining = 90;
    private boolean detonating = false;

    public CodNukeBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.COD_NUKE.get(), pos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("timer", this.remaining);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.remaining = tag.getInt("timer");
    }

    public void sync() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        CodNukeBlockEntity blockEntity = (CodNukeBlockEntity)be;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.getGameTime() % 20L == 0L) {
                serverLevel.playSound(null, blockEntity.worldPosition, (SoundEvent)CodSounds.BEEP.get(), SoundSource.MASTER, 3.0f, 1.0f);
                --blockEntity.remaining;
                blockEntity.setChanged();
                blockEntity.sync();
            }
            if (blockEntity.remaining == 1) {
                if (!blockEntity.detonating) {
                    serverLevel.playSound(null, blockEntity.worldPosition, (SoundEvent)CodSounds.DETONATION.get(), SoundSource.MASTER, 16.0f, 1.0f);
                }
                blockEntity.detonating = true;
            }
            if (blockEntity.remaining == 0) {
                CodNukeBlockEntity.explode(blockEntity.worldPosition, serverLevel);
                serverLevel.setBlock(blockEntity.worldPosition, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    public int getRemaining() {
        return this.remaining;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    private static void explode(BlockPos pos, ServerLevel serverLevel) {
        Vec3 codSpawnPos = pos.getCenter();
        serverLevel.playSound(null, pos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.MASTER, 16.0f, 1.0f);
        for (int i = 0; i < 1024; ++i) {
            ItemStack stack = new ItemStack((ItemLike)Items.COD, 1);
            ItemProjectileEntity codProjectile = new ItemProjectileEntity((EntityType<? extends ItemProjectileEntity>)((EntityType)CodEntities.ITEM_PROJECTILE.get()), (Level)serverLevel, stack, 20, 100, false);
            double yaw = serverLevel.random.nextDouble() * Math.PI * 4.0;
            double pitch = serverLevel.random.nextDouble() - 0.5;
            double speed = 1.0;
            codProjectile.setDeltaMovement(Math.cos(yaw) * Math.cos(pitch) * speed, Math.sin(pitch) * speed + 0.4, Math.sin(yaw) * Math.cos(pitch) * speed);
            codProjectile.setPos(codSpawnPos);
            serverLevel.addFreshEntity((Entity)codProjectile);
        }
    }
}

