/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.opticalDriveInterface;

import com.mc3699.codmod.block.opticalDriveInterface.OpticalDriveInterfaceBlockEntity;
import com.mc3699.codmod.item.OpticalTapeDriveItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OpticalDriveInterfaceBlock
extends Block
implements EntityBlock {
    public static BooleanProperty HAS_DISK = BooleanProperty.create((String)"has_disk");

    public OpticalDriveInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HAS_DISK, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_DISK});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        OpticalDriveInterfaceBlockEntity drive;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof OpticalDriveInterfaceBlockEntity && (drive = (OpticalDriveInterfaceBlockEntity)blockEntity).getDisk().isEmpty() && stack.getItem() instanceof OpticalTapeDriveItem) {
            ItemStack toInsert = stack.copyWithCount(1);
            drive.setDisk(toInsert);
            stack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_DISK, (Comparable)Boolean.valueOf(true)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        OpticalDriveInterfaceBlockEntity drive;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof OpticalDriveInterfaceBlockEntity && !(drive = (OpticalDriveInterfaceBlockEntity)blockEntity).getDisk().isEmpty()) {
            ItemStack ejectDisk = drive.getDisk().copyAndClear();
            player.getInventory().add(ejectDisk);
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_DISK, (Comparable)Boolean.valueOf(false)), 3);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new OpticalDriveInterfaceBlockEntity(blockPos, blockState);
    }
}

