/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.dimension.backrooms;

import com.mc3699.codmod.dimension.backrooms.BackroomsStructures;
import com.mc3699.codmod.registry.CodBlocks;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;

public class BRGenUtil {
    public static Random random = new Random();

    public static void fillArea(ChunkAccess chunk, int startX, int startY, int startZ, int endX, int endY, int endZ, BlockState state) {
        int minX = Math.min(startX, endX);
        int minY = Math.min(startY, endY);
        int minZ = Math.min(startZ, endZ);
        int maxX = Math.max(startX, endX);
        int maxY = Math.max(startY, endY);
        int maxZ = Math.max(startZ, endZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    chunk.setBlockState(pos, state, true);
                }
            }
        }
    }

    public static void fillLayer(ChunkAccess chunk, int layer, BlockState state) {
        BRGenUtil.fillArea(chunk, 0, layer, 0, 15, layer, 15, state);
        chunk.initializeLightSources();
    }

    public static void generateBasicWalls(ChunkAccess chunk, int floorLevel, int ceilingLevel, BlockState state) {
        int startX = random.nextInt(0, 15);
        int startZ = random.nextInt(0, 15);
        int length = random.nextInt(1, 15);
        int wallThickness = random.nextInt(0, 6);
        if (random.nextBoolean()) {
            BRGenUtil.fillArea(chunk, startX, floorLevel + 1, startZ, startX + length, ceilingLevel - 1, startZ + wallThickness, state);
        } else {
            BRGenUtil.fillArea(chunk, startX, floorLevel + 1, startZ, startX + wallThickness, ceilingLevel - 1, startZ + length, state);
        }
    }

    public static BackroomsStructures.BackroomsStructureInfo rollStructure(List<BackroomsStructures.BackroomsStructureInfo> possibleStructures) {
        int index = random.nextInt(0, possibleStructures.size());
        return possibleStructures.get(index);
    }

    public static void generateLights(ChunkAccess chunk, int layer, boolean redLights) {
        ChunkPos chunkPos = chunk.getPos();
        for (int x = 0; x < 15; x += 4) {
            for (int z = 0; z < 15; z += 4) {
                BlockState lightState = CodBlocks.CEILING_LIGHT.getDefaultState();
                if (redLights) {
                    lightState = CodBlocks.RED_CEILING_LIGHT.getDefaultState();
                }
                chunk.setBlockState(chunkPos.getWorldPosition().offset(x, layer, z), lightState, true);
            }
        }
    }

    public static void generateBasicWallsWithExtension(ChunkAccess chunk, int floorLevel, int ceilingLevel, BlockState wallState, int extensionOffset, BlockState extensionState) {
        int startX = random.nextInt(0, 15);
        int startZ = random.nextInt(0, 15);
        int length = random.nextInt(5, 15);
        int wallThickness = random.nextInt(0, 4);
        if (random.nextBoolean()) {
            BRGenUtil.fillArea(chunk, startX, floorLevel + 1, startZ, startX + length, ceilingLevel - 1, startZ + wallThickness, wallState);
            BRGenUtil.fillArea(chunk, startX, ceilingLevel + 1, startZ, startX + length, ceilingLevel + extensionOffset, startZ + wallThickness, extensionState);
        } else {
            BRGenUtil.fillArea(chunk, startX, floorLevel + 1, startZ, startX + wallThickness, ceilingLevel - 1, startZ + length, wallState);
            BRGenUtil.fillArea(chunk, startX, ceilingLevel + 1, startZ, startX + wallThickness, ceilingLevel + extensionOffset, startZ + length, extensionState);
        }
    }

    public static boolean isChunkInNoise(ChunkAccess chunk, PerlinNoise noise, double threshold) {
        double scale = 0.1;
        double noiseValue = noise.getValue((double)chunk.getPos().x * scale, (double)chunk.getPos().z * scale, 0.0);
        return noiseValue > threshold;
    }

    public static void fillWall(ChunkAccess chunk, int startX, int startZ, int endX, int endZ, int startLayer, int endLayer, Block block) {
        for (int height = startLayer; height < endLayer + 1; ++height) {
            for (int ix = startX; ix < endX; ++ix) {
                for (int iz = startZ; iz < endZ; ++iz) {
                    chunk.setBlockState(chunk.getPos().getWorldPosition().offset(ix, height, iz), block.defaultBlockState(), true);
                }
            }
        }
    }

    public static void placeBackroomsStructure(BackroomsStructures.BackroomsStructureInfo structureInfo, WorldGenRegion world, BlockPos startPos, RandomSource random) {
        StructureTemplateManager templateManager = world.getLevel().getStructureManager();
        Optional structureTemplate = templateManager.get(structureInfo.structure());
        if (structureTemplate.isPresent()) {
            StructureTemplate template = (StructureTemplate)structureTemplate.get();
            StructurePlaceSettings placeSettings = new StructurePlaceSettings().setRandom(random).setIgnoreEntities(true);
            template.placeInWorld((ServerLevelAccessor)world, startPos, startPos.offset((Vec3i)structureInfo.offset()), placeSettings, random, 2);
        }
    }
}

