/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.ariral;

import com.mc3699.codmod.entity.ariral.AriralEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AriralEntityRenderer
extends LivingEntityRenderer<AriralEntity, PlayerModel<AriralEntity>> {
    ResourceLocation RENDER_TYPE = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"ariral");

    public AriralEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.0f);
    }

    public void render(AriralEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        RenderType renderType = VeilRenderType.get((ResourceLocation)this.RENDER_TYPE, (Object[])new Object[]{"codmod:textures/entity/ariral.png"});
        if (renderType == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(1.0f, 1.0f, 1.0f);
        float limbSwing = entity.walkAnimation.position(partialTicks);
        float limbSwingAmount = entity.walkAnimation.speed(partialTicks);
        VertexConsumer transparentBuffer = buffer.getBuffer(renderType);
        ((PlayerModel)this.model).setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, (float)entity.tickCount, entityYaw, entity.yHeadRot);
        poseStack.popPose();
    }

    protected boolean shouldShowName(AriralEntity entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(AriralEntity ariralEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/entity/ariral.png");
    }
}

