/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.cod_almighty;

import com.mc3699.codmod.entity.cod_almighty.CodAlmightyRandomFlyGoal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CodAlmightyEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(CodAlmightyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_SHOOTING = SynchedEntityData.defineId(CodAlmightyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float aimYaw;
    public float aimPitch;
    public float prevAimYaw;
    public float prevAimPitch;
    public final AnimationState idleAnim = new AnimationState();
    public final AnimationState shootAnim = new AnimationState();
    private int idleAnimTime = 0;
    private int shootAnimTime = 0;

    public CodAlmightyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 5, true);
        this.navigation = new FlyingPathNavigation((Mob)this, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_ID, (Object)-1);
        builder.define(IS_SHOOTING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FLYING_SPEED, 8.0).add(Attributes.FOLLOW_RANGE, 128.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(10, (Goal)new CodAlmightyRandomFlyGoal(this, 5.0));
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    private void setupAnim() {
        if (this.idleAnimTime <= 0) {
            this.idleAnimTime = 80;
            this.idleAnim.start(this.tickCount);
        } else {
            --this.idleAnimTime;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            player.startRiding((Entity)this);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnim();
        }
        if (this.level().isClientSide()) {
            float targetPitch;
            float targetYaw;
            LivingEntity target = this.getSyncedTarget();
            if (target != null) {
                double dx = target.getX() - this.getX();
                double dz = target.getZ() - this.getZ();
                double dy = target.getEyeY() - this.getEyeY();
                targetYaw = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 270.0f;
                targetPitch = (float)(-Mth.atan2((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232);
            } else {
                targetYaw = this.getYRot();
                targetPitch = this.getXRot();
            }
            this.prevAimYaw = this.aimYaw;
            this.prevAimPitch = this.aimPitch;
            this.aimYaw = Mth.approachDegrees((float)this.aimYaw, (float)targetYaw, (float)1.0f);
            this.aimPitch = Mth.approachDegrees((float)this.aimPitch, (float)targetPitch, (float)1.0f);
        }
    }

    public LivingEntity getSyncedTarget() {
        Entity entity;
        int targetId = (Integer)this.getEntityData().get(TARGET_ID);
        if (targetId != -1 && (entity = this.level().getEntity(targetId)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    static final class BOSS_STAGE
    extends Enum<BOSS_STAGE> {
        private static final /* synthetic */ BOSS_STAGE[] $VALUES;

        public static BOSS_STAGE[] values() {
            return (BOSS_STAGE[])$VALUES.clone();
        }

        public static BOSS_STAGE valueOf(String name) {
            return Enum.valueOf(BOSS_STAGE.class, name);
        }

        private static /* synthetic */ BOSS_STAGE[] $values() {
            return new BOSS_STAGE[0];
        }

        static {
            $VALUES = BOSS_STAGE.$values();
        }
    }
}

