/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.darkener;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AttackPlayerInLightGoal
extends Goal {
    private final PathfinderMob entity;
    private final Level level;
    private final double speed;
    private Player target;

    public AttackPlayerInLightGoal(PathfinderMob entity, double speed) {
        this.entity = entity;
        this.level = entity.level();
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, true));
    }

    public boolean canUse() {
        this.target = (Player)this.entity.getTarget();
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        BlockPos targetPos = this.target.blockPosition();
        return this.level.getBrightness(LightLayer.BLOCK, targetPos) > 4 || this.level.getBrightness(LightLayer.SKY, targetPos) > 4;
    }

    public void start() {
        if (this.target != null) {
            this.entity.getNavigation().moveTo((Entity)this.target, this.speed);
            this.entity.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.entity.getMaxHeadXRot());
        }
    }

    public boolean canContinueToUse() {
        if (this.target == null || !this.target.isAlive() || this.entity.getNavigation().isDone()) {
            return false;
        }
        BlockPos targetPos = this.target.blockPosition();
        return this.level.getBrightness(LightLayer.BLOCK, targetPos) > 4 || this.level.getBrightness(LightLayer.SKY, targetPos) > 4;
    }

    public void tick() {
        if (this.target != null) {
            this.entity.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.entity.getMaxHeadXRot());
            this.entity.getNavigation().moveTo((Entity)this.target, this.speed);
            if (this.target.getY() > this.entity.getY() + 1.5) {
                BlockPos entityPos = this.entity.blockPosition();
                BlockPos belowPos = entityPos.below();
                BlockState belowState = this.level.getBlockState(belowPos);
                this.entity.getJumpControl().jump();
                if (belowState.isAir() || belowState.canBeReplaced()) {
                    this.level.setBlock(belowPos, Blocks.DIRT.defaultBlockState(), 3);
                    this.entity.getJumpControl().jump();
                }
            }
            if (this.entity.distanceToSqr((Entity)this.target) <= 4.0) {
                this.entity.doHurtTarget((Entity)this.target);
            }
        }
    }

    public void stop() {
        this.target = null;
        this.entity.getNavigation().stop();
    }
}

