/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.darkener;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class DestroyLightsGoal
extends Goal {
    private final PathfinderMob entity;
    private final Level level;
    private final double speed;
    private final int range;
    private BlockPos targetPos;

    public DestroyLightsGoal(PathfinderMob entity, double speed, int range) {
        this.entity = entity;
        this.level = entity.level();
        this.speed = speed;
        this.range = range;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.entity.tickCount % 20 == 0 || this.targetPos == null) {
            this.targetPos = this.findClosestLightEmittingBlock();
        }
        return this.targetPos != null;
    }

    public void start() {
        if (this.targetPos != null) {
            Path path = this.entity.getNavigation().createPath((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 2);
            this.entity.getNavigation().moveTo(path, this.speed);
        }
    }

    public boolean canContinueToUse() {
        if (this.targetPos == null) {
            return false;
        }
        BlockState state = this.level.getBlockState(this.targetPos);
        return !this.entity.getNavigation().isDone() && state.getLightEmission((BlockGetter)this.level, this.targetPos) > 0 && this.isBlockReachable(this.targetPos);
    }

    public void tick() {
        if (this.targetPos != null) {
            this.entity.getLookControl().setLookAt((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 10.0f, (float)this.entity.getMaxHeadXRot());
            if (this.entity.distanceToSqr((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5) <= 25.0) {
                this.level.destroyBlock(this.targetPos, true, (Entity)this.entity);
                this.targetPos = null;
                this.entity.getNavigation().stop();
            } else if (this.entity.getNavigation().isDone()) {
                Path path = this.entity.getNavigation().createPath((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 2);
                this.entity.getNavigation().moveTo(path, this.speed);
            }
        }
    }

    public void stop() {
        this.targetPos = null;
        this.entity.getNavigation().stop();
    }

    private BlockPos findClosestLightEmittingBlock() {
        BlockPos entityPos = this.entity.blockPosition();
        BlockPos closestPos = null;
        double closestDistSq = Double.MAX_VALUE;
        for (int x = -this.range; x <= this.range; ++x) {
            for (int y = -this.range; y <= this.range; ++y) {
                for (int z = -this.range; z <= this.range; ++z) {
                    double distSq;
                    BlockPos pos = entityPos.offset(x, y, z);
                    BlockState state = this.level.getBlockState(pos);
                    if (state.getLightEmission((BlockGetter)this.level, pos) <= 0 || !this.isBlockDestructible(state, pos) || !this.isBlockReachable(pos) || !((distSq = this.entity.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)) < closestDistSq)) continue;
                    closestDistSq = distSq;
                    closestPos = pos;
                }
            }
        }
        return closestPos;
    }

    private boolean isBlockReachable(BlockPos pos) {
        Path path = this.entity.getNavigation().createPath((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 2);
        return path != null && path.canReach();
    }

    private boolean isBlockDestructible(BlockState state, BlockPos pos) {
        return state.getDestroySpeed((BlockGetter)this.level, pos) >= 0.0f && !state.isAir() && !state.liquid();
    }
}

