/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.firelight;

import com.mc3699.codmod.registry.CodMobEffects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AttackOrDisappearGoal
extends Goal {
    private final PathfinderMob entity;
    private final Level level;
    private final double approachDistance;
    private final double attackSpeed;
    private final float disappearChance;
    private final Random random;
    private final UUID firelightUUID = UUID.fromString("494de44d-eee2-4e82-8b11-5cd7997976e8");
    private Player target;
    private boolean attacking = false;

    public AttackOrDisappearGoal(PathfinderMob entity, Level level, double approachDistance, double attackSpeed, float disappearChance) {
        this.entity = entity;
        this.level = level;
        this.approachDistance = approachDistance;
        this.attackSpeed = attackSpeed;
        this.disappearChance = disappearChance;
        this.random = new Random();
        this.entity.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, false));
    }

    public boolean canUse() {
        this.target = (Player)this.entity.getTarget();
        return this.target != null && this.target.isAlive() && !this.target.getUUID().equals(this.firelightUUID);
    }

    public void start() {
        this.entity.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.entity.getMaxHeadXRot());
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive();
    }

    public void tick() {
        if (this.target != null) {
            this.entity.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.entity.getMaxHeadXRot());
            if (this.entity.distanceToSqr((Entity)this.target) < this.approachDistance * this.approachDistance) {
                if (this.random.nextFloat() < this.disappearChance && !this.attacking) {
                    this.entity.discard();
                } else {
                    this.entity.getNavigation().moveTo((Entity)this.target, this.attackSpeed);
                    if (this.entity.distanceToSqr((Entity)this.target) < 2.0) {
                        this.entity.doHurtTarget((Entity)this.target);
                        this.target.removeEffect(CodMobEffects.HEART_CORRUPTION);
                        this.target.addEffect(new MobEffectInstance(CodMobEffects.HEART_CORRUPTION, -1, this.random.nextInt(1, 10)));
                    }
                    this.attacking = true;
                }
            }
        }
    }

    public void stop() {
        this.target = null;
        this.entity.getNavigation().stop();
    }
}

