/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.parachuteChest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ParachuteChestEntity
extends Entity {
    private final ItemStackHandler items;

    public ParachuteChestEntity(EntityType<ParachuteChestEntity> type, Level level, ItemStackHandler items) {
        super(type, level);
        this.items = items;
    }

    public boolean isNoGravity() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.position().y > 128.0) {
            this.move(MoverType.SELF, new Vec3(0.0, (double)-0.8f, 0.0));
        } else {
            this.move(MoverType.SELF, new Vec3(0.0, (double)-0.2f, 0.0));
        }
        if (this.onGround()) {
            BlockPos chestPos = this.getOnPos().above();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.setBlock(chestPos, (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH), 3);
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)serverLevel.getBlockEntity(chestPos);
                for (int i = 0; i < this.items.getSlots(); ++i) {
                    ItemStack stack = this.items.getStackInSlot(i);
                    assert (chestBlockEntity != null);
                    chestBlockEntity.setItem(i, stack);
                    chestBlockEntity.setChanged();
                }
            }
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.items.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundTag.getCompound("inventory"));
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.put("inventory", (Tag)this.items.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }
}

