/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.wisp;

import com.mc3699.codmod.entity.wisp.BaseWispEntity;
import com.mc3699.codmod.entity.wisp.BaseWispModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.PointLight;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BaseWispEntityRenderer
extends MobRenderer<BaseWispEntity, BaseWispModel> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/entity/base_wisp.png");
    private static final Map<BaseWispEntity, PointLight> entityPointLightMap = new WeakHashMap<BaseWispEntity, PointLight>();

    public BaseWispEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BaseWispModel(context.bakeLayer(BaseWispModel.LAYER_LOCATION)), 0.0f);
    }

    public static void cleanup() {
        entityPointLightMap.entrySet().removeIf(entry -> {
            if (((BaseWispEntity)((Object)((Object)entry.getKey()))).isRemoved()) {
                VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)((PointLight)entry.getValue()));
                return true;
            }
            return false;
        });
    }

    public void render(BaseWispEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        PointLight pointLight = entityPointLightMap.computeIfAbsent(entity, e -> {
            PointLight newLight = new PointLight();
            VeilRenderSystem.renderer().getLightRenderer().addLight((Light)newLight);
            return newLight;
        });
        pointLight.setPosition(entity.getX(), entity.getY() + 0.8, entity.getZ());
        pointLight.setRadius(10.0f);
        int color = entity.getColor();
        pointLight.setColor(color);
        pointLight.setBrightness(3.0f);
        pointLight.markDirty();
        poseStack.pushPose();
        poseStack.translate(0.0f, 2.0f, 0.0f);
        ((BaseWispModel)this.model).setupAnim(entity, 0.0f, 0.0f, (float)entity.tickCount + partialTicks, entityYaw, 0.0f);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        poseStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(BaseWispEntity baseWispEntity) {
        return TEXTURE;
    }
}

