/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.wisp;

import com.mc3699.codmod.client.EntityAnimations;
import com.mc3699.codmod.entity.wisp.BaseWispEntity;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class BaseWispModel
extends HierarchicalModel<BaseWispEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"yellow_wisp"), "main");
    private final ModelPart body;
    private final ModelPart base;
    private final ModelPart outer;

    public BaseWispModel(ModelPart root) {
        this.body = root.getChild("body");
        this.base = this.body.getChild("base");
        this.outer = this.body.getChild("outer");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition base = body.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition outer = body.addOrReplaceChild("outer", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(1.5f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public ModelPart root() {
        return this.body;
    }

    private void animate(BaseWispEntity entity, AnimationDefinition animation, float time, float scale) {
        KeyframeAnimations.animate((HierarchicalModel)this, (AnimationDefinition)animation, (long)((long)(time * 1000.0f)), (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public void setupAnim(BaseWispEntity baseWispEntity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.root().xRot = 0.0f;
        float animTime = animationProgress / 20.0f;
        this.animate(baseWispEntity, EntityAnimations.WISP_MAIN, animTime, 1.0f);
    }
}

