/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.wisp.wispTypes;

import com.mc3699.codmod.entity.wisp.BaseWispEntity;
import com.mc3699.codmod.entity.wisp.BaseWispModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.PointLight;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class DistortedWispEntityRenderer
extends MobRenderer<BaseWispEntity, BaseWispModel> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/entity/base_wisp.png");
    private static final Map<BaseWispEntity, PointLight> entityPointLightMap = new WeakHashMap<BaseWispEntity, PointLight>();

    public DistortedWispEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BaseWispModel(context.bakeLayer(BaseWispModel.LAYER_LOCATION)), 0.0f);
    }

    public static void cleanup() {
        entityPointLightMap.entrySet().removeIf(entry -> {
            if (((BaseWispEntity)((Object)((Object)entry.getKey()))).isRemoved()) {
                VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)((PointLight)entry.getValue()));
                return true;
            }
            return false;
        });
    }

    public void render(BaseWispEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        VertexConsumer consumer = buffer.getBuffer(RenderType.END_PORTAL);
        poseStack.pushPose();
        poseStack.translate(0.0f, 2.0f, 0.0f);
        ((BaseWispModel)this.model).renderToBuffer(poseStack, consumer, 65280, 65280);
        ((BaseWispModel)this.model).setupAnim(entity, 0.0f, 0.0f, (float)entity.tickCount, 0.0f, 0.0f);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(BaseWispEntity baseWispEntity) {
        return TEXTURE;
    }
}

