/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.Codmod;
import com.mc3699.codmod.registry.CodDamageTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CodRodItem
extends MaceItem {
    public static final Logger LOGGER = LogManager.getLogger();

    public CodRodItem(Item.Properties props) {
        super(props);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!Codmod.hasOperatorPermission(player)) {
                if (!player.level().isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"item.codmod.no_permission").withStyle(ChatFormatting.RED), true);
                    LOGGER.info(player.getName().getString() + " has tried to use The Cod Rod but isnt an Operator!");
                }
                stack.shrink(stack.getCount());
                return true;
            }
            Vec3 codSpawnPos = entity.getPosition(0.0f);
            DamageSource dam = new DamageSource((Holder)player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.COD_ROD));
            if (entity instanceof ServerPlayer) {
                ServerPlayer hitPlayer = (ServerPlayer)entity;
                entity.hurt(dam, 1000.0f);
            } else {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            serverLevel.playSound(null, BlockPos.containing((Position)codSpawnPos), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.PLAYERS);
            for (int i = 0; i < 8; ++i) {
                Cod cod = new Cod(EntityType.COD, (Level)serverLevel);
                cod.setPos(codSpawnPos);
                int randomVelX = serverLevel.random.nextInt(-4, 4);
                int randomVelZ = serverLevel.random.nextInt(-4, 4);
                int randomHeight = serverLevel.random.nextInt(8, 24);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, codSpawnPos.x, codSpawnPos.y, codSpawnPos.z, 2, 0.0, 1.0, 0.0, (double)randomVelX);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, codSpawnPos.x, codSpawnPos.y, codSpawnPos.z, 32, 0.0, 1.0, 0.0, (double)randomVelX * 0.01);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, codSpawnPos.x, codSpawnPos.y, codSpawnPos.z, 4, 0.0, 1.0, 0.0, 0.01);
                cod.setDeltaMovement((double)randomVelX * 0.1, (double)randomHeight * 0.05, (double)randomVelZ * 0.1);
                serverLevel.addFreshEntity((Entity)cod);
            }
        }
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Player player;
        return !(miningEntity instanceof Player) || !(player = (Player)miningEntity).isCreative();
    }
}

