/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.marksmanRevolver;

import com.mc3699.codmod.entity.MarksmanRevolverCoinEntity;
import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MarksmanRevolverItem
extends Item {
    public MarksmanRevolverItem(Item.Properties properties) {
        super(properties);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        Level level;
        if (entity instanceof Player && (level = (player = (Player)entity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fireRaycast(serverLevel, player);
        }
        return false;
    }

    public static void spawnParticleLine(ServerLevel level, Vec3 from, Vec3 to, ParticleOptions particle, int steps) {
        Vec3 delta = to.subtract(from);
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            Vec3 point = from.add(delta.scale(t));
            level.sendParticles(particle, point.x, point.y, point.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        Vec3 look = player.getLookAngle().scale(1.5);
        Vec3 coinSpawnPos = new Vec3(look.x, -0.5, look.z);
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            MarksmanRevolverCoinEntity coinEntity = new MarksmanRevolverCoinEntity((EntityType<? extends ItemProjectileEntity>)((EntityType)CodEntities.MARKSMAN_COIN_ENTITY.get()), (Level)serverLevel);
            coinEntity.setPos(player.getEyePosition().add(coinSpawnPos));
            Vec3 launcVec = player.getLookAngle().scale(0.3);
            coinEntity.setDeltaMovement(new Vec3(0.0, 0.6, 0.0).add(launcVec));
            coinEntity.setOwner((Entity)player);
            serverLevel.addFreshEntity((Entity)coinEntity);
            serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.COIN.value(), SoundSource.MASTER, 1.0f, 1.0f);
        }
        return super.use(level, player, usedHand);
    }

    private void fireRaycast(ServerLevel serverLevel, Player player) {
        double maxRange = 250.0;
        Vec3 start = player.getEyePosition(1.0f);
        Vec3 angle = player.getLookAngle().scale(maxRange);
        Vec3 end = start.add(angle.scale(maxRange));
        BlockHitResult blockHitResult = serverLevel.clip(new ClipContext(start, angle, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        MarksmanRevolverItem.spawnParticleLine(serverLevel, start.add(0.0, -0.25, 0.0), angle.scale(10.0), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 100);
        AABB hitZone = player.getBoundingBox().expandTowards(angle.scale(maxRange));
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)start, (Vec3)end, (AABB)hitZone, entity -> true, (double)1.0E9);
        if (hitResult != null) {
            MarksmanRevolverItem.spawnParticleLine(serverLevel, start.add(0.0, -0.25, 0.0), hitResult.getLocation(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 100);
            Entity entity2 = hitResult.getEntity();
            if (entity2 instanceof MarksmanRevolverCoinEntity) {
                MarksmanRevolverCoinEntity coinEntity = (MarksmanRevolverCoinEntity)entity2;
                coinEntity.hit(player);
            }
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, (start.x + end.x) / 2.0, (start.y + end.y) / 2.0, (start.z + end.z) / 2.0, 10, (end.x - start.x) / 2.0, (end.y - start.y) / 2.0, (end.z - start.z) / 2.0, 0.1);
            hitResult.getEntity().hurt(serverLevel.damageSources().playerAttack(player), 5.0f);
        }
    }
}

