/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.network;

import com.mc3699.codmod.client.ClientOxygen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OxygenClientPayload(int oxygenSaturation) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"oxygen_info");
    public static final CustomPacketPayload.Type<OxygenClientPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, OxygenClientPayload> CODEC = StreamCodec.of((buf, pck) -> buf.writeInt(pck.oxygenSaturation), buf -> new OxygenClientPayload(buf.readInt()));

    public static void handle(OxygenClientPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientOxygen.oxygenSaturation = payload.oxygenSaturation;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

