/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.peripheral;

import com.mc3699.codmod.block.uavController.UAVControllerBlockEntity;
import com.mc3699.codmod.entity.uav.UAVEntity;
import com.mc3699.codmod.registry.CodEntities;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class UAVControllerPeripheral
implements IPeripheral {
    private final UAVControllerBlockEntity blockEntity;

    public UAVControllerPeripheral(UAVControllerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public String getType() {
        return "uav_controller";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }

    @LuaFunction
    public final boolean summonUAV() {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.blockEntity.getUAVEntity(serverLevel) != null) {
                return false;
            }
            BlockPos pos = this.blockEntity.getBlockPos().above();
            UAVEntity uav = (UAVEntity)EntityTypeExt.INSTANCE.trySummonTyped((EntityType)CodEntities.UAV.get(), (LevelAccessor)serverLevel, pos.getCenter().add(0.5, 0.0, 0.5));
            uav.setLinkedController(pos);
            this.blockEntity.setUavUUID(uav.getUUID());
            this.blockEntity.setChanged();
            return true;
        }
        return false;
    }

    @LuaFunction
    public final boolean destroyUAV() {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.blockEntity.getUAVEntity(serverLevel) == null) {
                return false;
            }
            UAVEntity uav = this.blockEntity.getUAVEntity(serverLevel);
            uav.discard();
        }
        return true;
    }

    @LuaFunction
    public final boolean setTarget(double x, double y, double z, int altitude, boolean followTerrain) {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UAVEntity uav = this.blockEntity.getUAVEntity(serverLevel);
            if (uav != null) {
                uav.setTargetPos(new Vec3(x, y, z));
                uav.setAltitude(altitude);
                uav.setTerrainFollowing(followTerrain);
                return true;
            }
            return false;
        }
        return false;
    }

    @LuaFunction
    public final boolean hasArrived(int threshold) {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UAVEntity uav = this.blockEntity.getUAVEntity(serverLevel);
            if (uav != null) {
                return uav.isAtTarget(threshold);
            }
            return false;
        }
        return false;
    }

    @LuaFunction
    public final Map<String, Double> getPos() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UAVEntity uav = this.blockEntity.getUAVEntity(serverLevel);
            if (uav != null) {
                Vec3 pos = uav.getPosition(0.0f);
                result.put("x", pos.x);
                result.put("y", pos.y);
                result.put("z", pos.z);
            } else {
                result.put("x", 0.0);
                result.put("y", 0.0);
                result.put("z", 0.0);
            }
        }
        return result;
    }

    @LuaFunction
    public final Map<Integer, Map<String, Object>> scanEntities(double radius) {
        ServerLevel serverLevel;
        UAVEntity uav;
        HashMap<Integer, Map<String, Object>> result = new HashMap<Integer, Map<String, Object>>();
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel && (uav = this.blockEntity.getUAVEntity(serverLevel = (ServerLevel)level)) != null) {
            Vec3 uavPos = uav.getPosition(0.0f);
            AABB aabb = new AABB(uavPos.x - radius, uavPos.y - radius, uavPos.z - radius, uavPos.x + radius, uavPos.y + radius, uavPos.z + radius);
            List entities = serverLevel.getEntities((Entity)null, aabb, entity -> entity != uav);
            int index = 0;
            for (Entity entity2 : entities) {
                HashMap<String, Object> entityData = new HashMap<String, Object>();
                entityData.put("type", entity2.getType().getDescriptionId());
                entityData.put("x", entity2.getX());
                entityData.put("y", entity2.getY());
                entityData.put("z", entity2.getZ());
                entityData.put("uuid", entity2.getUUID().toString());
                result.put(index++, entityData);
            }
        }
        return result;
    }
}

