/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.mantleKey;

import com.mc3699.codmod.block.mantleKey.MantleKeyBlock;
import com.mc3699.codmod.registry.CodBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MantleKeyBlockEntity
extends BlockEntity {
    private int beamLength = 1;

    public MantleKeyBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.MANTLE_KEY.get(), pos, blockState);
    }

    public static void applyRedstone(ServerLevel level, BlockPos startPos, Direction facing, int range) {
        BlockPos pos = startPos;
        for (int i = 0; i < range; ++i) {
            if (!level.isLoaded(pos = pos.offset(facing.getNormal()))) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            if (!state.hasProperty((Property)RedStoneWireBlock.POWER)) continue;
            BlockState newState = (BlockState)state.setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(15));
            level.setBlock(pos, newState, 3);
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        MantleKeyBlockEntity blockEntity = (MantleKeyBlockEntity)level.getBlockEntity(blockPos);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MantleKeyBlockEntity.applyRedstone(serverLevel, blockPos, (Direction)blockState.getValue((Property)MantleKeyBlock.FACING), blockEntity.getBeamLength());
            if (blockEntity.getBeamLength() <= 64) {
                blockEntity.setBeamLength(blockEntity.getBeamLength() + 1);
            }
        }
    }

    public int getBeamLength() {
        return this.beamLength;
    }

    public void setBeamLength(int beamLen) {
        this.beamLength = beamLen;
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("beam_length", this.beamLength);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.beamLength = tag.getInt("beam_length");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

