/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.subspace_tripmine;

import com.mc3699.codmod.registry.CodDamageTypes;
import com.mc3699.codmod.registry.CodSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class SubspaceTripmineBlock
extends Block {
    public SubspaceTripmineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.playSound(null, pos, (SoundEvent)CodSounds.TRIPMINE.get(), SoundSource.MASTER, 128.0f, 1.0f);
            serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            DamageSource tripmineDamage = new DamageSource((Holder)level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.SUBSPACE_TRIPMINE));
            AABB damageBounds = new AABB(pos).inflate(16.0);
            List nearEntities = serverLevel.getEntitiesOfClass(LivingEntity.class, damageBounds);
            nearEntities.forEach(target -> {
                if (target.distanceToSqr(pos.getCenter()) <= 256.0) {
                    target.hurt(tripmineDamage, 1000.0f);
                }
            });
        }
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)0.8, (double)0.9);
    }

    public void spawnParticleSphere(Entity entity, BlockPos center, double radius) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int radiusCeil = (int)Math.ceil(radius);
            for (int x = -radiusCeil; x <= radiusCeil; ++x) {
                for (int y = -radiusCeil; y <= radiusCeil; ++y) {
                    for (int z = -radiusCeil; z <= radiusCeil; ++z) {
                        BlockPos pos = center.offset(x, y, z);
                        if (!(pos.distSqr((Vec3i)center) <= radius * radius)) continue;
                        serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 1.0f), 3.0f), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }
}

