/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.client;

import com.mc3699.codmod.entity.wisp.BaseWispEntityRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.wendigodrip.thebrokenscript.api.util.Boxes;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Matrix4fc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="codmod")
public class ClientEvents {
    @SubscribeEvent
    public static void onClientTickEnd(ClientTickEvent.Post event) {
        BaseWispEntityRenderer.cleanup();
    }

    public static void register() {
    }

    private static void onRenderLevel(VeilRenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, MultiBufferSource.BufferSource bufferSource, MatrixStack matrixStack, Matrix4fc frustumMatrix, Matrix4fc projectionMatrix, int renderTick, DeltaTracker deltaTracker, Camera camera, Frustum frustum) {
        if (stage != VeilRenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Minecraft john = Minecraft.getInstance();
        LocalPlayer player = Objects.requireNonNull(john.player);
        ClientLevel level = Objects.requireNonNull(john.level);
        float sunAngle = level.getSunAngle(0.0f) + 1.5707964f;
        float x = (float)Math.cos(sunAngle) * 700.0f;
        float y = (float)Math.sin(sunAngle) * 700.0f;
        float z = 0.0f;
        Vec3 sunPos = new Vec3((double)x, (double)y, (double)z);
        Vec3 camPos = camera.getPosition();
        PoseStack ps = matrixStack.toPoseStack();
        ps.pushPose();
        ps.translate(-camPos.x, -camPos.y, -camPos.z);
        DebugRenderer.renderFilledBox((PoseStack)ps, (MultiBufferSource)bufferSource, (AABB)Boxes.INSTANCE.aabb(sunPos.add(player.position()), (Number)1).inflate(20.0), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ps.popPose();
    }

    static {
        ClientEvents.register();
    }
}

