/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.darkener;

import com.mc3699.codmod.entity.darkener.AttackPlayerInLightGoal;
import com.mc3699.codmod.entity.darkener.DestroyLightsGoal;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;

public class DarkenerEntity
extends PathfinderMob {
    private final int DESPAWN_TIME = 6000;

    public DarkenerEntity(EntityType<DarkenerEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AttackPlayerInLightGoal(this, 1.8f));
        this.goalSelector.addGoal(5, (Goal)new DestroyLightsGoal(this, 1.25, 16));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 6000) {
            this.discard();
        }
    }
}

