/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.gianni;

import com.mc3699.codmod.entity.gianni.GianniEntity;
import com.mc3699.codmod.registry.CodItems;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GianniEntityRenderer
extends EntityRenderer<GianniEntity> {
    private final ItemRenderer itemRenderer;
    private final Random random = new Random();

    public GianniEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTextureLocation(GianniEntity gianniEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/item/gianni.png");
    }

    public void render(GianniEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float glitchBounds = 0.05f;
        poseStack.translate((double)this.random.nextFloat(-glitchBounds, glitchBounds), 1.5, (double)(0.0f + this.random.nextFloat(-glitchBounds, glitchBounds)));
        poseStack.translate(0.0f, -0.5f, 0.0f);
        poseStack.scale(6.0f, 6.0f, 6.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        ItemStack stackItem = new ItemStack((ItemLike)CodItems.GIANNI.get());
        BakedModel model = this.itemRenderer.getModel(stackItem, entity.level(), null, 0);
        this.itemRenderer.render(stackItem, ItemDisplayContext.GROUND, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

