/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.itemProjectile;

import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class ItemProjectileRenderer
extends EntityRenderer<ItemProjectileEntity> {
    private final ItemRenderer itemRenderer;

    public ItemProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(ItemProjectileEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        Vec3 velocity = entity.getDeltaMovement();
        float yaw = (float)(Mth.atan2((double)velocity.x, (double)velocity.z) * 57.29577951308232);
        float pitch = (float)(Mth.atan2((double)velocity.y, (double)velocity.horizontalDistance()) * 57.29577951308232);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.translate(0.0, 0.2, 0.0);
        ItemStack item = entity.getCarriedItem().isEmpty() ? new ItemStack((ItemLike)Items.COD) : entity.getCarriedItem();
        this.itemRenderer.renderStatic(item, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, entity.level(), entity.getId());
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(ItemProjectileEntity itemProjectileEntity) {
        return null;
    }
}

