/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.trialTrader;

import com.mc3699.codmod.entity.trialTrader.RepairTask;
import com.mc3699.codmod.entity.trialTrader.TrialTraderEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class RepairGoal
extends Goal {
    private final TrialTraderEntity entity;
    private RepairTask currentTask;
    private int timeoutCounter;

    public RepairGoal(TrialTraderEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        List<RepairTask> tasks = this.entity.getRepairTasks();
        if (!tasks.isEmpty()) {
            this.currentTask = tasks.get(0);
            return true;
        }
        return false;
    }

    public void start() {
        BlockPos pos = this.currentTask.pos();
        this.entity.getNavigation().moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0);
        this.timeoutCounter = 0;
    }

    public void tick() {
        if (this.currentTask != null) {
            BlockPos pos = this.currentTask.pos();
            Level level = this.entity.level();
            if (this.entity.blockPosition().closerThan((Vec3i)pos, 2.0)) {
                if (level.getBlockState(pos).isAir()) {
                    level.setBlock(pos, this.currentTask.state(), 3);
                    if (this.currentTask.blockEntity() != null) {
                        level.setBlockEntity(this.currentTask.blockEntity());
                    }
                    this.entity.getRepairTasks().remove(this.currentTask);
                    this.entity.setTarget((LivingEntity)this.currentTask.breaker());
                    this.currentTask = null;
                }
            } else {
                ++this.timeoutCounter;
                if (this.timeoutCounter > 1200) {
                    this.entity.getRepairTasks().remove(this.currentTask);
                    this.currentTask = null;
                }
            }
        }
    }

    public boolean canContinueToUse() {
        return this.currentTask != null && !this.entity.getRepairTasks().isEmpty();
    }
}

