/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.handlers;

import com.mc3699.codmod.colors.ColorManager;
import com.mc3699.codmod.network.ClientBadSunSyncPayload;
import com.mc3699.codmod.network.FoliageColorPayload;
import com.mc3699.codmod.registry.CodDamageTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="codmod", bus=EventBusSubscriber.Bus.GAME)
public class BadSunEvents {
    private static final Random random = new Random();
    public static boolean isBadSunDay = false;
    private static long tickCount = 0L;

    private static boolean isInSun(ServerPlayer player) {
        if (player.isCreative() || player.isSpectator()) {
            return false;
        }
        MinecraftServer server = player.getServer();
        if (server == null) {
            return false;
        }
        if (!player.level().isDay()) {
            return false;
        }
        ServerLevel level = player.serverLevel();
        Vec3 sunPos = BadSunEvents.getSunDirection((Level)level, 0.0f).scale(1000.0);
        return level.canSeeSky(player.blockPosition()) && level.clip(new ClipContext(player.position().add(new Vec3(0.0, 1.62, 0.0)), sunPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player)).getType() == HitResult.Type.MISS;
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (isBadSunDay && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new FoliageColorPayload(15520650, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientBadSunSyncPayload(isBadSunDay), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ColorManager.resetFoliageColor();
        ColorManager.resetGrassColor();
    }

    public static Vec3 getSunDirection(Level level, float partialTicks) {
        float sunAngle = level.getSunAngle(partialTicks);
        double x = -Math.sin(sunAngle);
        double y = Math.cos(sunAngle);
        double z = 0.0;
        return new Vec3(x, y, z).normalize();
    }

    @SubscribeEvent
    public static void removeKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DamageSource badSunDamage = new DamageSource((Holder)player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.BAD_SUN));
            if (player.getLastDamageSource() != null && player.getLastDamageSource().type().equals((Object)badSunDamage.type())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void badSunTick(ServerTickEvent.Post event) {
        ++tickCount;
        List players = event.getServer().getPlayerList().getPlayers();
        ServerLevel overworld = event.getServer().overworld();
        if (overworld.isNight() && isBadSunDay) {
            isBadSunDay = false;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new FoliageColorPayload(0, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClientBadSunSyncPayload(isBadSunDay), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (tickCount % 20L == 0L && isBadSunDay) {
            for (ServerPlayer player : players) {
                if (!BadSunEvents.isInSun(player)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBadSunSyncPayload(isBadSunDay), (CustomPacketPayload[])new CustomPacketPayload[0]);
                DamageSource badSunDamage = new DamageSource((Holder)player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.BAD_SUN));
                player.hurt(badSunDamage, 2.0f);
                ItemStack fleshItem = new ItemStack((ItemLike)Items.ROTTEN_FLESH, 1);
                ItemEntity fleshEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), fleshItem);
                fleshEntity.setPickUpDelay(20);
                float fleshEjectionRange = 0.25f;
                float randX = random.nextFloat(-fleshEjectionRange, fleshEjectionRange);
                float randY = random.nextFloat(0.0f, fleshEjectionRange);
                float randZ = random.nextFloat(-fleshEjectionRange, fleshEjectionRange);
                player.level().addFreshEntity((Entity)fleshEntity);
                fleshEntity.setDeltaMovement((double)randX, (double)randY, (double)randZ);
            }
        }
    }
}

